/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/routing.proto

// Protobuf Java Version: 3.25.5
package com.google.api;

/**
 *
 *
 * <pre>
 * Specifies the routing information that should be sent along with the request
 * in the form of routing header.
 * **NOTE:** All service configuration rules follow the "last one wins" order.
 *
 * The examples below will apply to an RPC which has the following request type:
 *
 * Message Definition:
 *
 *     message Request {
 *       // The name of the Table
 *       // Values can be of the following formats:
 *       // - `projects/&lt;project&gt;/tables/&lt;table&gt;`
 *       // - `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`
 *       // - `region/&lt;region&gt;/zones/&lt;zone&gt;/tables/&lt;table&gt;`
 *       string table_name = 1;
 *
 *       // This value specifies routing for replication.
 *       // It can be in the following formats:
 *       // - `profiles/&lt;profile_id&gt;`
 *       // - a legacy `profile_id` that can be any string
 *       string app_profile_id = 2;
 *     }
 *
 * Example message:
 *
 *     {
 *       table_name: projects/proj_foo/instances/instance_bar/table/table_baz,
 *       app_profile_id: profiles/prof_qux
 *     }
 *
 * The routing header consists of one or multiple key-value pairs. Every key
 * and value must be percent-encoded, and joined together in the format of
 * `key1=value1&amp;key2=value2`.
 * In the examples below I am skipping the percent-encoding for readablity.
 *
 * Example 1
 *
 * Extracting a field from the request to put into the routing header
 * unchanged, with the key equal to the field name.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // Take the `app_profile_id`.
 *       routing_parameters {
 *         field: "app_profile_id"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params: app_profile_id=profiles/prof_qux
 *
 * Example 2
 *
 * Extracting a field from the request to put into the routing header
 * unchanged, with the key different from the field name.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // Take the `app_profile_id`, but name it `routing_id` in the header.
 *       routing_parameters {
 *         field: "app_profile_id"
 *         path_template: "{routing_id=**}"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params: routing_id=profiles/prof_qux
 *
 * Example 3
 *
 * Extracting a field from the request to put into the routing
 * header, while matching a path template syntax on the field's value.
 *
 * NB: it is more useful to send nothing than to send garbage for the purpose
 * of dynamic routing, since garbage pollutes cache. Thus the matching.
 *
 * Sub-example 3a
 *
 * The field matches the template.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // Take the `table_name`, if it's well-formed (with project-based
 *       // syntax).
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{table_name=projects/&#42;&#47;instances/&#42;&#47;&#42;*}"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params:
 *     table_name=projects/proj_foo/instances/instance_bar/table/table_baz
 *
 * Sub-example 3b
 *
 * The field does not match the template.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // Take the `table_name`, if it's well-formed (with region-based
 *       // syntax).
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{table_name=regions/&#42;&#47;zones/&#42;&#47;&#42;*}"
 *       }
 *     };
 *
 * result:
 *
 *     &lt;no routing header will be sent&gt;
 *
 * Sub-example 3c
 *
 * Multiple alternative conflictingly named path templates are
 * specified. The one that matches is used to construct the header.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // Take the `table_name`, if it's well-formed, whether
 *       // using the region- or projects-based syntax.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{table_name=regions/&#42;&#47;zones/&#42;&#47;&#42;*}"
 *       }
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{table_name=projects/&#42;&#47;instances/&#42;&#47;&#42;*}"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params:
 *     table_name=projects/proj_foo/instances/instance_bar/table/table_baz
 *
 * Example 4
 *
 * Extracting a single routing header key-value pair by matching a
 * template syntax on (a part of) a single request field.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // Take just the project id from the `table_name` field.
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{routing_id=projects/&#42;}/&#42;*"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params: routing_id=projects/proj_foo
 *
 * Example 5
 *
 * Extracting a single routing header key-value pair by matching
 * several conflictingly named path templates on (parts of) a single request
 * field. The last template to match "wins" the conflict.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // If the `table_name` does not have instances information,
 *       // take just the project id for routing.
 *       // Otherwise take project + instance.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{routing_id=projects/&#42;}/&#42;*"
 *       }
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{routing_id=projects/&#42;&#47;instances/&#42;}/&#42;*"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params:
 *     routing_id=projects/proj_foo/instances/instance_bar
 *
 * Example 6
 *
 * Extracting multiple routing header key-value pairs by matching
 * several non-conflicting path templates on (parts of) a single request field.
 *
 * Sub-example 6a
 *
 * Make the templates strict, so that if the `table_name` does not
 * have an instance information, nothing is sent.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // The routing code needs two keys instead of one composite
 *       // but works only for the tables with the "project-instance" name
 *       // syntax.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{project_id=projects/&#42;}/instances/&#42;&#47;&#42;*"
 *       }
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "projects/&#42;&#47;{instance_id=instances/&#42;}/&#42;*"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params:
 *     project_id=projects/proj_foo&amp;instance_id=instances/instance_bar
 *
 * Sub-example 6b
 *
 * Make the templates loose, so that if the `table_name` does not
 * have an instance information, just the project id part is sent.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // The routing code wants two keys instead of one composite
 *       // but will work with just the `project_id` for tables without
 *       // an instance in the `table_name`.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{project_id=projects/&#42;}/&#42;*"
 *       }
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "projects/&#42;&#47;{instance_id=instances/&#42;}/&#42;*"
 *       }
 *     };
 *
 * result (is the same as 6a for our example message because it has the instance
 * information):
 *
 *     x-goog-request-params:
 *     project_id=projects/proj_foo&amp;instance_id=instances/instance_bar
 *
 * Example 7
 *
 * Extracting multiple routing header key-value pairs by matching
 * several path templates on multiple request fields.
 *
 * NB: note that here there is no way to specify sending nothing if one of the
 * fields does not match its template. E.g. if the `table_name` is in the wrong
 * format, the `project_id` will not be sent, but the `routing_id` will be.
 * The backend routing code has to be aware of that and be prepared to not
 * receive a full complement of keys if it expects multiple.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // The routing needs both `project_id` and `routing_id`
 *       // (from the `app_profile_id` field) for routing.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{project_id=projects/&#42;}/&#42;*"
 *       }
 *       routing_parameters {
 *         field: "app_profile_id"
 *         path_template: "{routing_id=**}"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params:
 *     project_id=projects/proj_foo&amp;routing_id=profiles/prof_qux
 *
 * Example 8
 *
 * Extracting a single routing header key-value pair by matching
 * several conflictingly named path templates on several request fields. The
 * last template to match "wins" the conflict.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // The `routing_id` can be a project id or a region id depending on
 *       // the table name format, but only if the `app_profile_id` is not set.
 *       // If `app_profile_id` is set it should be used instead.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{routing_id=projects/&#42;}/&#42;*"
 *       }
 *       routing_parameters {
 *          field: "table_name"
 *          path_template: "{routing_id=regions/&#42;}/&#42;*"
 *       }
 *       routing_parameters {
 *         field: "app_profile_id"
 *         path_template: "{routing_id=**}"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params: routing_id=profiles/prof_qux
 *
 * Example 9
 *
 * Bringing it all together.
 *
 * annotation:
 *
 *     option (google.api.routing) = {
 *       // For routing both `table_location` and a `routing_id` are needed.
 *       //
 *       // table_location can be either an instance id or a region+zone id.
 *       //
 *       // For `routing_id`, take the value of `app_profile_id`
 *       // - If it's in the format `profiles/&lt;profile_id&gt;`, send
 *       // just the `&lt;profile_id&gt;` part.
 *       // - If it's any other literal, send it as is.
 *       // If the `app_profile_id` is empty, and the `table_name` starts with
 *       // the project_id, send that instead.
 *
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "projects/&#42;&#47;{table_location=instances/&#42;}/tables/&#42;"
 *       }
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{table_location=regions/&#42;&#47;zones/&#42;}/tables/&#42;"
 *       }
 *       routing_parameters {
 *         field: "table_name"
 *         path_template: "{routing_id=projects/&#42;}/&#42;*"
 *       }
 *       routing_parameters {
 *         field: "app_profile_id"
 *         path_template: "{routing_id=**}"
 *       }
 *       routing_parameters {
 *         field: "app_profile_id"
 *         path_template: "profiles/{routing_id=*}"
 *       }
 *     };
 *
 * result:
 *
 *     x-goog-request-params:
 *     table_location=instances/instance_bar&amp;routing_id=prof_qux
 * </pre>
 *
 * Protobuf type {@code google.api.RoutingRule}
 */
public final class RoutingRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.RoutingRule)
    RoutingRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RoutingRule.newBuilder() to construct.
  private RoutingRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RoutingRule() {
    routingParameters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RoutingRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.RoutingProto.internal_static_google_api_RoutingRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.RoutingProto.internal_static_google_api_RoutingRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.RoutingRule.class, com.google.api.RoutingRule.Builder.class);
  }

  public static final int ROUTING_PARAMETERS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.RoutingParameter> routingParameters_;
  /**
   *
   *
   * <pre>
   * A collection of Routing Parameter specifications.
   * **NOTE:** If multiple Routing Parameters describe the same key
   * (via the `path_template` field or via the `field` field when
   * `path_template` is not provided), "last one wins" rule
   * determines which Parameter gets used.
   * See the examples for more details.
   * </pre>
   *
   * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.RoutingParameter> getRoutingParametersList() {
    return routingParameters_;
  }
  /**
   *
   *
   * <pre>
   * A collection of Routing Parameter specifications.
   * **NOTE:** If multiple Routing Parameters describe the same key
   * (via the `path_template` field or via the `field` field when
   * `path_template` is not provided), "last one wins" rule
   * determines which Parameter gets used.
   * See the examples for more details.
   * </pre>
   *
   * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.RoutingParameterOrBuilder>
      getRoutingParametersOrBuilderList() {
    return routingParameters_;
  }
  /**
   *
   *
   * <pre>
   * A collection of Routing Parameter specifications.
   * **NOTE:** If multiple Routing Parameters describe the same key
   * (via the `path_template` field or via the `field` field when
   * `path_template` is not provided), "last one wins" rule
   * determines which Parameter gets used.
   * See the examples for more details.
   * </pre>
   *
   * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
   */
  @java.lang.Override
  public int getRoutingParametersCount() {
    return routingParameters_.size();
  }
  /**
   *
   *
   * <pre>
   * A collection of Routing Parameter specifications.
   * **NOTE:** If multiple Routing Parameters describe the same key
   * (via the `path_template` field or via the `field` field when
   * `path_template` is not provided), "last one wins" rule
   * determines which Parameter gets used.
   * See the examples for more details.
   * </pre>
   *
   * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
   */
  @java.lang.Override
  public com.google.api.RoutingParameter getRoutingParameters(int index) {
    return routingParameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A collection of Routing Parameter specifications.
   * **NOTE:** If multiple Routing Parameters describe the same key
   * (via the `path_template` field or via the `field` field when
   * `path_template` is not provided), "last one wins" rule
   * determines which Parameter gets used.
   * See the examples for more details.
   * </pre>
   *
   * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
   */
  @java.lang.Override
  public com.google.api.RoutingParameterOrBuilder getRoutingParametersOrBuilder(int index) {
    return routingParameters_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < routingParameters_.size(); i++) {
      output.writeMessage(2, routingParameters_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < routingParameters_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, routingParameters_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.RoutingRule)) {
      return super.equals(obj);
    }
    com.google.api.RoutingRule other = (com.google.api.RoutingRule) obj;

    if (!getRoutingParametersList().equals(other.getRoutingParametersList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRoutingParametersCount() > 0) {
      hash = (37 * hash) + ROUTING_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getRoutingParametersList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.RoutingRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.RoutingRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.RoutingRule parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.RoutingRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.RoutingRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.RoutingRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.RoutingRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.RoutingRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.RoutingRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.RoutingRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.RoutingRule parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.RoutingRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.RoutingRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the routing information that should be sent along with the request
   * in the form of routing header.
   * **NOTE:** All service configuration rules follow the "last one wins" order.
   *
   * The examples below will apply to an RPC which has the following request type:
   *
   * Message Definition:
   *
   *     message Request {
   *       // The name of the Table
   *       // Values can be of the following formats:
   *       // - `projects/&lt;project&gt;/tables/&lt;table&gt;`
   *       // - `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`
   *       // - `region/&lt;region&gt;/zones/&lt;zone&gt;/tables/&lt;table&gt;`
   *       string table_name = 1;
   *
   *       // This value specifies routing for replication.
   *       // It can be in the following formats:
   *       // - `profiles/&lt;profile_id&gt;`
   *       // - a legacy `profile_id` that can be any string
   *       string app_profile_id = 2;
   *     }
   *
   * Example message:
   *
   *     {
   *       table_name: projects/proj_foo/instances/instance_bar/table/table_baz,
   *       app_profile_id: profiles/prof_qux
   *     }
   *
   * The routing header consists of one or multiple key-value pairs. Every key
   * and value must be percent-encoded, and joined together in the format of
   * `key1=value1&amp;key2=value2`.
   * In the examples below I am skipping the percent-encoding for readablity.
   *
   * Example 1
   *
   * Extracting a field from the request to put into the routing header
   * unchanged, with the key equal to the field name.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // Take the `app_profile_id`.
   *       routing_parameters {
   *         field: "app_profile_id"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params: app_profile_id=profiles/prof_qux
   *
   * Example 2
   *
   * Extracting a field from the request to put into the routing header
   * unchanged, with the key different from the field name.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // Take the `app_profile_id`, but name it `routing_id` in the header.
   *       routing_parameters {
   *         field: "app_profile_id"
   *         path_template: "{routing_id=**}"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params: routing_id=profiles/prof_qux
   *
   * Example 3
   *
   * Extracting a field from the request to put into the routing
   * header, while matching a path template syntax on the field's value.
   *
   * NB: it is more useful to send nothing than to send garbage for the purpose
   * of dynamic routing, since garbage pollutes cache. Thus the matching.
   *
   * Sub-example 3a
   *
   * The field matches the template.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // Take the `table_name`, if it's well-formed (with project-based
   *       // syntax).
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{table_name=projects/&#42;&#47;instances/&#42;&#47;&#42;*}"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params:
   *     table_name=projects/proj_foo/instances/instance_bar/table/table_baz
   *
   * Sub-example 3b
   *
   * The field does not match the template.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // Take the `table_name`, if it's well-formed (with region-based
   *       // syntax).
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{table_name=regions/&#42;&#47;zones/&#42;&#47;&#42;*}"
   *       }
   *     };
   *
   * result:
   *
   *     &lt;no routing header will be sent&gt;
   *
   * Sub-example 3c
   *
   * Multiple alternative conflictingly named path templates are
   * specified. The one that matches is used to construct the header.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // Take the `table_name`, if it's well-formed, whether
   *       // using the region- or projects-based syntax.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{table_name=regions/&#42;&#47;zones/&#42;&#47;&#42;*}"
   *       }
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{table_name=projects/&#42;&#47;instances/&#42;&#47;&#42;*}"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params:
   *     table_name=projects/proj_foo/instances/instance_bar/table/table_baz
   *
   * Example 4
   *
   * Extracting a single routing header key-value pair by matching a
   * template syntax on (a part of) a single request field.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // Take just the project id from the `table_name` field.
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{routing_id=projects/&#42;}/&#42;*"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params: routing_id=projects/proj_foo
   *
   * Example 5
   *
   * Extracting a single routing header key-value pair by matching
   * several conflictingly named path templates on (parts of) a single request
   * field. The last template to match "wins" the conflict.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // If the `table_name` does not have instances information,
   *       // take just the project id for routing.
   *       // Otherwise take project + instance.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{routing_id=projects/&#42;}/&#42;*"
   *       }
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{routing_id=projects/&#42;&#47;instances/&#42;}/&#42;*"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params:
   *     routing_id=projects/proj_foo/instances/instance_bar
   *
   * Example 6
   *
   * Extracting multiple routing header key-value pairs by matching
   * several non-conflicting path templates on (parts of) a single request field.
   *
   * Sub-example 6a
   *
   * Make the templates strict, so that if the `table_name` does not
   * have an instance information, nothing is sent.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // The routing code needs two keys instead of one composite
   *       // but works only for the tables with the "project-instance" name
   *       // syntax.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{project_id=projects/&#42;}/instances/&#42;&#47;&#42;*"
   *       }
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "projects/&#42;&#47;{instance_id=instances/&#42;}/&#42;*"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params:
   *     project_id=projects/proj_foo&amp;instance_id=instances/instance_bar
   *
   * Sub-example 6b
   *
   * Make the templates loose, so that if the `table_name` does not
   * have an instance information, just the project id part is sent.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // The routing code wants two keys instead of one composite
   *       // but will work with just the `project_id` for tables without
   *       // an instance in the `table_name`.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{project_id=projects/&#42;}/&#42;*"
   *       }
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "projects/&#42;&#47;{instance_id=instances/&#42;}/&#42;*"
   *       }
   *     };
   *
   * result (is the same as 6a for our example message because it has the instance
   * information):
   *
   *     x-goog-request-params:
   *     project_id=projects/proj_foo&amp;instance_id=instances/instance_bar
   *
   * Example 7
   *
   * Extracting multiple routing header key-value pairs by matching
   * several path templates on multiple request fields.
   *
   * NB: note that here there is no way to specify sending nothing if one of the
   * fields does not match its template. E.g. if the `table_name` is in the wrong
   * format, the `project_id` will not be sent, but the `routing_id` will be.
   * The backend routing code has to be aware of that and be prepared to not
   * receive a full complement of keys if it expects multiple.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // The routing needs both `project_id` and `routing_id`
   *       // (from the `app_profile_id` field) for routing.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{project_id=projects/&#42;}/&#42;*"
   *       }
   *       routing_parameters {
   *         field: "app_profile_id"
   *         path_template: "{routing_id=**}"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params:
   *     project_id=projects/proj_foo&amp;routing_id=profiles/prof_qux
   *
   * Example 8
   *
   * Extracting a single routing header key-value pair by matching
   * several conflictingly named path templates on several request fields. The
   * last template to match "wins" the conflict.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // The `routing_id` can be a project id or a region id depending on
   *       // the table name format, but only if the `app_profile_id` is not set.
   *       // If `app_profile_id` is set it should be used instead.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{routing_id=projects/&#42;}/&#42;*"
   *       }
   *       routing_parameters {
   *          field: "table_name"
   *          path_template: "{routing_id=regions/&#42;}/&#42;*"
   *       }
   *       routing_parameters {
   *         field: "app_profile_id"
   *         path_template: "{routing_id=**}"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params: routing_id=profiles/prof_qux
   *
   * Example 9
   *
   * Bringing it all together.
   *
   * annotation:
   *
   *     option (google.api.routing) = {
   *       // For routing both `table_location` and a `routing_id` are needed.
   *       //
   *       // table_location can be either an instance id or a region+zone id.
   *       //
   *       // For `routing_id`, take the value of `app_profile_id`
   *       // - If it's in the format `profiles/&lt;profile_id&gt;`, send
   *       // just the `&lt;profile_id&gt;` part.
   *       // - If it's any other literal, send it as is.
   *       // If the `app_profile_id` is empty, and the `table_name` starts with
   *       // the project_id, send that instead.
   *
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "projects/&#42;&#47;{table_location=instances/&#42;}/tables/&#42;"
   *       }
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{table_location=regions/&#42;&#47;zones/&#42;}/tables/&#42;"
   *       }
   *       routing_parameters {
   *         field: "table_name"
   *         path_template: "{routing_id=projects/&#42;}/&#42;*"
   *       }
   *       routing_parameters {
   *         field: "app_profile_id"
   *         path_template: "{routing_id=**}"
   *       }
   *       routing_parameters {
   *         field: "app_profile_id"
   *         path_template: "profiles/{routing_id=*}"
   *       }
   *     };
   *
   * result:
   *
   *     x-goog-request-params:
   *     table_location=instances/instance_bar&amp;routing_id=prof_qux
   * </pre>
   *
   * Protobuf type {@code google.api.RoutingRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.RoutingRule)
      com.google.api.RoutingRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.RoutingProto.internal_static_google_api_RoutingRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.RoutingProto.internal_static_google_api_RoutingRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.RoutingRule.class, com.google.api.RoutingRule.Builder.class);
    }

    // Construct using com.google.api.RoutingRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (routingParametersBuilder_ == null) {
        routingParameters_ = java.util.Collections.emptyList();
      } else {
        routingParameters_ = null;
        routingParametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.RoutingProto.internal_static_google_api_RoutingRule_descriptor;
    }

    @java.lang.Override
    public com.google.api.RoutingRule getDefaultInstanceForType() {
      return com.google.api.RoutingRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.RoutingRule build() {
      com.google.api.RoutingRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.RoutingRule buildPartial() {
      com.google.api.RoutingRule result = new com.google.api.RoutingRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.RoutingRule result) {
      if (routingParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          routingParameters_ = java.util.Collections.unmodifiableList(routingParameters_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.routingParameters_ = routingParameters_;
      } else {
        result.routingParameters_ = routingParametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.RoutingRule result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.RoutingRule) {
        return mergeFrom((com.google.api.RoutingRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.RoutingRule other) {
      if (other == com.google.api.RoutingRule.getDefaultInstance()) return this;
      if (routingParametersBuilder_ == null) {
        if (!other.routingParameters_.isEmpty()) {
          if (routingParameters_.isEmpty()) {
            routingParameters_ = other.routingParameters_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRoutingParametersIsMutable();
            routingParameters_.addAll(other.routingParameters_);
          }
          onChanged();
        }
      } else {
        if (!other.routingParameters_.isEmpty()) {
          if (routingParametersBuilder_.isEmpty()) {
            routingParametersBuilder_.dispose();
            routingParametersBuilder_ = null;
            routingParameters_ = other.routingParameters_;
            bitField0_ = (bitField0_ & ~0x00000001);
            routingParametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRoutingParametersFieldBuilder()
                    : null;
          } else {
            routingParametersBuilder_.addAllMessages(other.routingParameters_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.api.RoutingParameter m =
                    input.readMessage(com.google.api.RoutingParameter.parser(), extensionRegistry);
                if (routingParametersBuilder_ == null) {
                  ensureRoutingParametersIsMutable();
                  routingParameters_.add(m);
                } else {
                  routingParametersBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.api.RoutingParameter> routingParameters_ =
        java.util.Collections.emptyList();

    private void ensureRoutingParametersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        routingParameters_ =
            new java.util.ArrayList<com.google.api.RoutingParameter>(routingParameters_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.RoutingParameter,
            com.google.api.RoutingParameter.Builder,
            com.google.api.RoutingParameterOrBuilder>
        routingParametersBuilder_;

    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public java.util.List<com.google.api.RoutingParameter> getRoutingParametersList() {
      if (routingParametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routingParameters_);
      } else {
        return routingParametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public int getRoutingParametersCount() {
      if (routingParametersBuilder_ == null) {
        return routingParameters_.size();
      } else {
        return routingParametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public com.google.api.RoutingParameter getRoutingParameters(int index) {
      if (routingParametersBuilder_ == null) {
        return routingParameters_.get(index);
      } else {
        return routingParametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder setRoutingParameters(int index, com.google.api.RoutingParameter value) {
      if (routingParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutingParametersIsMutable();
        routingParameters_.set(index, value);
        onChanged();
      } else {
        routingParametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder setRoutingParameters(
        int index, com.google.api.RoutingParameter.Builder builderForValue) {
      if (routingParametersBuilder_ == null) {
        ensureRoutingParametersIsMutable();
        routingParameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        routingParametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder addRoutingParameters(com.google.api.RoutingParameter value) {
      if (routingParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutingParametersIsMutable();
        routingParameters_.add(value);
        onChanged();
      } else {
        routingParametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder addRoutingParameters(int index, com.google.api.RoutingParameter value) {
      if (routingParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutingParametersIsMutable();
        routingParameters_.add(index, value);
        onChanged();
      } else {
        routingParametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder addRoutingParameters(com.google.api.RoutingParameter.Builder builderForValue) {
      if (routingParametersBuilder_ == null) {
        ensureRoutingParametersIsMutable();
        routingParameters_.add(builderForValue.build());
        onChanged();
      } else {
        routingParametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder addRoutingParameters(
        int index, com.google.api.RoutingParameter.Builder builderForValue) {
      if (routingParametersBuilder_ == null) {
        ensureRoutingParametersIsMutable();
        routingParameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        routingParametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder addAllRoutingParameters(
        java.lang.Iterable<? extends com.google.api.RoutingParameter> values) {
      if (routingParametersBuilder_ == null) {
        ensureRoutingParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, routingParameters_);
        onChanged();
      } else {
        routingParametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder clearRoutingParameters() {
      if (routingParametersBuilder_ == null) {
        routingParameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        routingParametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public Builder removeRoutingParameters(int index) {
      if (routingParametersBuilder_ == null) {
        ensureRoutingParametersIsMutable();
        routingParameters_.remove(index);
        onChanged();
      } else {
        routingParametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public com.google.api.RoutingParameter.Builder getRoutingParametersBuilder(int index) {
      return getRoutingParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public com.google.api.RoutingParameterOrBuilder getRoutingParametersOrBuilder(int index) {
      if (routingParametersBuilder_ == null) {
        return routingParameters_.get(index);
      } else {
        return routingParametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public java.util.List<? extends com.google.api.RoutingParameterOrBuilder>
        getRoutingParametersOrBuilderList() {
      if (routingParametersBuilder_ != null) {
        return routingParametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routingParameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public com.google.api.RoutingParameter.Builder addRoutingParametersBuilder() {
      return getRoutingParametersFieldBuilder()
          .addBuilder(com.google.api.RoutingParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public com.google.api.RoutingParameter.Builder addRoutingParametersBuilder(int index) {
      return getRoutingParametersFieldBuilder()
          .addBuilder(index, com.google.api.RoutingParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of Routing Parameter specifications.
     * **NOTE:** If multiple Routing Parameters describe the same key
     * (via the `path_template` field or via the `field` field when
     * `path_template` is not provided), "last one wins" rule
     * determines which Parameter gets used.
     * See the examples for more details.
     * </pre>
     *
     * <code>repeated .google.api.RoutingParameter routing_parameters = 2;</code>
     */
    public java.util.List<com.google.api.RoutingParameter.Builder>
        getRoutingParametersBuilderList() {
      return getRoutingParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.RoutingParameter,
            com.google.api.RoutingParameter.Builder,
            com.google.api.RoutingParameterOrBuilder>
        getRoutingParametersFieldBuilder() {
      if (routingParametersBuilder_ == null) {
        routingParametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.RoutingParameter,
                com.google.api.RoutingParameter.Builder,
                com.google.api.RoutingParameterOrBuilder>(
                routingParameters_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        routingParameters_ = null;
      }
      return routingParametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.RoutingRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.RoutingRule)
  private static final com.google.api.RoutingRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.RoutingRule();
  }

  public static com.google.api.RoutingRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RoutingRule> PARSER =
      new com.google.protobuf.AbstractParser<RoutingRule>() {
        @java.lang.Override
        public RoutingRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RoutingRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RoutingRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.RoutingRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
