/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.NumHelper;
import com.vividsolutions.jts.geom.Point;

public class GHPoint {
    public double lat = Double.NaN;
    public double lon = Double.NaN;

    public GHPoint() {
    }

    public GHPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public static GHPoint create(Point point) {
        return new GHPoint(point.getY(), point.getX());
    }

    public static GHPoint fromString(String str) {
        return GHPoint.fromString(str, false);
    }

    public static GHPoint fromStringLonLat(String str) {
        return GHPoint.fromString(str, true);
    }

    public static GHPoint fromJson(double[] xy) {
        return new GHPoint(xy[1], xy[0]);
    }

    private static GHPoint fromString(String str, boolean lonLatOrder) {
        String[] fromStrs = str.split(",");
        if (fromStrs.length != 2) {
            throw new IllegalArgumentException("Cannot parse point '" + str + "'");
        }
        try {
            double fromLat = Double.parseDouble(fromStrs[0]);
            double fromLon = Double.parseDouble(fromStrs[1]);
            if (lonLatOrder) {
                return new GHPoint(fromLon, fromLat);
            }
            return new GHPoint(fromLat, fromLon);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Cannot parse point '" + str + "'");
        }
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public boolean isValid() {
        return !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        hash = 83 * hash + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        GHPoint other = (GHPoint)obj;
        return NumHelper.equalsEps(this.lat, other.lat) && NumHelper.equalsEps(this.lon, other.lon);
    }

    public String toString() {
        return this.lat + "," + this.lon;
    }

    public Double[] toGeoJson() {
        return new Double[]{this.lon, this.lat};
    }
}

