/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GraphHopperConfig {
    private List<Profile> profiles = new ArrayList<Profile>();
    private List<CHProfile> chProfiles = new ArrayList<CHProfile>();
    private List<LMProfile> lmProfiles = new ArrayList<LMProfile>();
    private final PMap map;

    public GraphHopperConfig() {
        this(new PMap());
    }

    public GraphHopperConfig(GraphHopperConfig otherConfig) {
        this.map = new PMap(otherConfig.map);
        this.profiles = new ArrayList<Profile>(otherConfig.profiles);
        this.chProfiles = new ArrayList<CHProfile>(otherConfig.chProfiles);
        this.lmProfiles = new ArrayList<LMProfile>(otherConfig.lmProfiles);
    }

    public GraphHopperConfig(PMap pMap) {
        this.map = pMap;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public GraphHopperConfig setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public List<CHProfile> getCHProfiles() {
        return this.chProfiles;
    }

    public GraphHopperConfig setCHProfiles(List<CHProfile> chProfiles) {
        this.chProfiles = chProfiles;
        return this;
    }

    public List<LMProfile> getLMProfiles() {
        return this.lmProfiles;
    }

    public GraphHopperConfig setLMProfiles(List<LMProfile> lmProfiles) {
        this.lmProfiles = lmProfiles;
        return this;
    }

    public GraphHopperConfig putObject(String key, Object value) {
        this.map.putObject(key, value);
        return this;
    }

    public boolean has(String key) {
        return this.map.has(key);
    }

    public boolean getBool(String key, boolean _default) {
        return this.map.getBool(key, _default);
    }

    public int getInt(String key, int _default) {
        return this.map.getInt(key, _default);
    }

    public long getLong(String key, long _default) {
        return this.map.getLong(key, _default);
    }

    public float getFloat(String key, float _default) {
        return this.map.getFloat(key, _default);
    }

    public double getDouble(String key, double _default) {
        return this.map.getDouble(key, _default);
    }

    public String getString(String key, String _default) {
        return this.map.getString(key, _default);
    }

    public PMap asPMap() {
        return this.map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("profiles:\n");
        for (Profile profile : this.profiles) {
            sb.append(profile);
            sb.append("\n");
        }
        sb.append("profiles_ch:\n");
        for (CHProfile cHProfile : this.chProfiles) {
            sb.append(cHProfile);
            sb.append("\n");
        }
        sb.append("profiles_lm:\n");
        for (LMProfile lMProfile : this.lmProfiles) {
            sb.append(lMProfile);
            sb.append("\n");
        }
        sb.append("properties:\n");
        for (Map.Entry entry : this.map.toMap().entrySet()) {
            sb.append((String)entry.getKey()).append(": ").append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

