/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import com.graphhopper.reader.osm.conditional.DateRange;
import com.graphhopper.reader.osm.conditional.ParsedCalendar;
import com.graphhopper.util.Helper;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class DateRangeParser
implements ConditionalValueParser {
    private static final DateFormat YEAR_MONTH_DAY_DF = Helper.createFormatter("yyyy MMM dd");
    private static final DateFormat MONTH_DAY_DF = Helper.createFormatter("MMM dd");
    private static final DateFormat MONTH_DAY2_DF = Helper.createFormatter("dd.MM");
    private static final DateFormat YEAR_MONTH_DF = Helper.createFormatter("yyyy MMM");
    private static final DateFormat MONTH_DF = Helper.createFormatter("MMM");
    private static final List<String> DAY_NAMES = Arrays.asList("Su", "Mo", "Tu", "We", "Th", "Fr", "Sa");
    private Calendar date;

    public DateRangeParser() {
        this(DateRangeParser.createCalendar());
    }

    public DateRangeParser(Calendar date) {
        this.date = date;
    }

    public static Calendar createCalendar() {
        return Calendar.getInstance(Helper.UTC, Locale.US);
    }

    static ParsedCalendar parseDateString(String dateString) throws ParseException {
        ParsedCalendar parsedCalendar;
        dateString = dateString.replaceAll("(,( )*)?(PH|SH)", "");
        dateString = dateString.trim();
        Calendar calendar = DateRangeParser.createCalendar();
        try {
            calendar.setTime(YEAR_MONTH_DAY_DF.parse(dateString));
            parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.YEAR_MONTH_DAY, calendar);
        }
        catch (ParseException e1) {
            try {
                calendar.setTime(MONTH_DAY_DF.parse(dateString));
                parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.MONTH_DAY, calendar);
            }
            catch (ParseException e2) {
                try {
                    calendar.setTime(MONTH_DAY2_DF.parse(dateString));
                    parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.MONTH_DAY, calendar);
                }
                catch (ParseException e3) {
                    try {
                        calendar.setTime(YEAR_MONTH_DF.parse(dateString));
                        parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.YEAR_MONTH, calendar);
                    }
                    catch (ParseException e4) {
                        try {
                            calendar.setTime(MONTH_DF.parse(dateString));
                            parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.MONTH, calendar);
                        }
                        catch (ParseException e5) {
                            int index = DAY_NAMES.indexOf(dateString);
                            if (index < 0) {
                                throw new ParseException("Unparseable date: \"" + dateString + "\"", 0);
                            }
                            calendar.set(7, index + 1);
                            parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.DAY, calendar);
                        }
                    }
                }
            }
        }
        return parsedCalendar;
    }

    public DateRange getRange(String dateRangeString) throws ParseException {
        if (dateRangeString == null || dateRangeString.isEmpty()) {
            throw new IllegalArgumentException("Passing empty Strings is not allowed");
        }
        String[] dateArr = dateRangeString.split("-");
        if (dateArr.length > 2 || dateArr.length < 1) {
            return null;
        }
        ParsedCalendar from = DateRangeParser.parseDateString(dateArr[0]);
        ParsedCalendar to = dateArr.length == 2 ? DateRangeParser.parseDateString(dateArr[1]) : DateRangeParser.parseDateString(dateArr[0]);
        return new DateRange(from, to);
    }

    @Override
    public ConditionalValueParser.ConditionState checkCondition(String dateRangeString) throws ParseException {
        DateRange dr = this.getRange(dateRangeString);
        if (dr == null) {
            return ConditionalValueParser.ConditionState.INVALID;
        }
        if (dr.isInRange(this.date)) {
            return ConditionalValueParser.ConditionState.TRUE;
        }
        return ConditionalValueParser.ConditionState.FALSE;
    }
}

