/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.Helper;
import java.util.PriorityQueue;

public class AStar
extends AbstractRoutingAlgorithm {
    private WeightApproximator weightApprox;
    private int visitedCount;
    private GHIntObjectHashMap<AStarEntry> fromMap;
    private PriorityQueue<AStarEntry> prioQueueOpenSet;
    private AStarEntry currEdge;
    private int to1 = -1;

    public AStar(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 2000);
        this.initCollections(size);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, weighting);
        defaultApprox.setDistanceCalc(Helper.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    public AStar setApproximation(WeightApproximator approx) {
        this.weightApprox = approx;
        return this;
    }

    protected void initCollections(int size) {
        this.fromMap = new GHIntObjectHashMap();
        this.prioQueueOpenSet = new PriorityQueue(size);
    }

    @Override
    public Path calcPath(int from, int to) {
        this.checkAlreadyRun();
        this.to1 = to;
        this.weightApprox.setTo(to);
        double weightToGoal = this.weightApprox.approximate(from);
        this.currEdge = new AStarEntry(-1, from, 0.0 + weightToGoal, 0.0);
        if (!this.traversalMode.isEdgeBased()) {
            this.fromMap.put(from, this.currEdge);
        }
        return this.runAlgo();
    }

    private Path runAlgo() {
        block6: {
            EdgeExplorer explorer = this.outEdgeExplorer;
            do {
                int currVertex = this.currEdge.adjNode;
                ++this.visitedCount;
                if (this.isMaxVisitedNodesExceeded()) {
                    return this.createEmptyPath();
                }
                if (this.finished()) break block6;
                EdgeIterator iter = explorer.setBaseNode(currVertex);
                while (iter.next()) {
                    int traversalId;
                    AStarEntry ase;
                    double alreadyVisitedWeight;
                    if (!this.accept(iter, this.currEdge.edge) || Double.isInfinite(alreadyVisitedWeight = this.weighting.calcWeight(iter, false, this.currEdge.edge) + this.currEdge.weightOfVisitedPath) || (ase = (AStarEntry)this.fromMap.get(traversalId = this.traversalMode.createTraversalId(iter, false))) != null && !(ase.weightOfVisitedPath > alreadyVisitedWeight)) continue;
                    int neighborNode = iter.getAdjNode();
                    double currWeightToGoal = this.weightApprox.approximate(neighborNode);
                    double estimationFullWeight = alreadyVisitedWeight + currWeightToGoal;
                    if (ase == null) {
                        ase = new AStarEntry(iter.getEdge(), neighborNode, estimationFullWeight, alreadyVisitedWeight);
                        this.fromMap.put(traversalId, ase);
                    } else {
                        this.prioQueueOpenSet.remove(ase);
                        ase.edge = iter.getEdge();
                        ase.weight = estimationFullWeight;
                        ase.weightOfVisitedPath = alreadyVisitedWeight;
                    }
                    ase.parent = this.currEdge;
                    this.prioQueueOpenSet.add(ase);
                    this.updateBestPath(iter, ase, traversalId);
                }
                if (this.prioQueueOpenSet.isEmpty()) {
                    return this.createEmptyPath();
                }
                this.currEdge = this.prioQueueOpenSet.poll();
            } while (this.currEdge != null);
            throw new AssertionError((Object)"Empty edge cannot happen");
        }
        return this.extractPath();
    }

    @Override
    protected Path extractPath() {
        return new Path(this.graph, this.weighting).setWeight(this.currEdge.weight).setSPTEntry(this.currEdge).extract();
    }

    @Override
    protected SPTEntry createSPTEntry(int node, double weight) {
        throw new IllegalStateException("use AStarEdge constructor directly");
    }

    @Override
    protected boolean finished() {
        return this.currEdge.adjNode == this.to1;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCount;
    }

    @Override
    public String getName() {
        return "astar|" + this.weightApprox;
    }

    public static class AStarEntry
    extends SPTEntry {
        double weightOfVisitedPath;

        public AStarEntry(int edgeId, int adjNode, double weightForHeap, double weightOfVisitedPath) {
            super(edgeId, adjNode, weightForHeap);
            this.weightOfVisitedPath = weightOfVisitedPath;
        }

        @Override
        public final double getWeightOfVisitedPath() {
            return this.weightOfVisitedPath;
        }
    }
}

