/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.RecalculationHook;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.ConsistentWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.PriorityQueue;

public class AStarBidirection
extends AbstractBidirAlgo
implements RecalculationHook {
    protected AStar.AStarEntry currFrom;
    protected AStar.AStarEntry currTo;
    protected PathBidirRef bestPath;
    protected IntObjectMap<AStar.AStarEntry> bestWeightMapFrom;
    protected IntObjectMap<AStar.AStarEntry> bestWeightMapTo;
    private IntObjectMap<AStar.AStarEntry> bestWeightMapOther;
    private ConsistentWeightApproximator weightApprox;
    private PriorityQueue<AStar.AStarEntry> pqOpenSetFrom;
    private PriorityQueue<AStar.AStarEntry> pqOpenSetTo;
    private IntHashSet ignoreExplorationFrom = new IntHashSet();
    private IntHashSet ignoreExplorationTo = new IntHashSet();
    private boolean updateBestPath = true;

    public AStarBidirection(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 150000);
        this.initCollections(size);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, weighting);
        defaultApprox.setDistanceCalc(Helper.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    protected void initCollections(int size) {
        this.pqOpenSetFrom = new PriorityQueue(size);
        this.bestWeightMapFrom = new GHIntObjectHashMap(size);
        this.pqOpenSetTo = new PriorityQueue(size);
        this.bestWeightMapTo = new GHIntObjectHashMap(size);
    }

    public AStarBidirection setApproximation(WeightApproximator approx) {
        this.weightApprox = new ConsistentWeightApproximator(approx);
        return this;
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    @Override
    protected SPTEntry createSPTEntry(int node, double weight) {
        throw new IllegalStateException("use AStarEdge constructor directly");
    }

    @Override
    public void initFrom(int from, double weight) {
        this.currFrom = new AStar.AStarEntry(-1, from, weight, weight);
        this.weightApprox.setFrom(from);
        this.pqOpenSetFrom.add(this.currFrom);
        if (this.currTo != null) {
            this.currFrom.weight += this.weightApprox.approximate(this.currFrom.adjNode, false);
            this.currTo.weight += this.weightApprox.approximate(this.currTo.adjNode, true);
        }
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapFrom.put(from, (Object)this.currFrom);
            if (this.currTo != null) {
                this.bestWeightMapOther = this.bestWeightMapTo;
                this.updateBestPath(GHUtility.getEdge(this.graph, from, this.currTo.adjNode), this.currTo, from);
            }
        } else if (this.currTo != null && this.currTo.adjNode == from) {
            this.bestPath.sptEntry = this.currFrom;
            this.bestPath.edgeTo = this.currTo;
            this.finishedFrom = true;
            this.finishedTo = true;
        }
    }

    @Override
    public void initTo(int to, double weight) {
        this.currTo = new AStar.AStarEntry(-1, to, weight, weight);
        this.weightApprox.setTo(to);
        this.pqOpenSetTo.add(this.currTo);
        if (this.currFrom != null) {
            this.currFrom.weight += this.weightApprox.approximate(this.currFrom.adjNode, false);
            this.currTo.weight += this.weightApprox.approximate(this.currTo.adjNode, true);
        }
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapTo.put(to, (Object)this.currTo);
            if (this.currFrom != null) {
                this.bestWeightMapOther = this.bestWeightMapFrom;
                this.updateBestPath(GHUtility.getEdge(this.graph, this.currFrom.adjNode, to), this.currFrom, to);
            }
        } else if (this.currFrom != null && this.currFrom.adjNode == to) {
            this.bestPath.sptEntry = this.currFrom;
            this.bestPath.edgeTo = this.currTo;
            this.finishedFrom = true;
            this.finishedTo = true;
        }
    }

    @Override
    protected Path createAndInitPath() {
        this.bestPath = new PathBidirRef(this.graph, this.weighting);
        return this.bestPath;
    }

    @Override
    protected Path extractPath() {
        if (this.finished()) {
            return this.bestPath.extract();
        }
        return this.bestPath;
    }

    @Override
    protected double getCurrentFromWeight() {
        return this.currFrom.weight;
    }

    @Override
    protected double getCurrentToWeight() {
        return this.currTo.weight;
    }

    @Override
    protected boolean finished() {
        if (this.finishedFrom || this.finishedTo) {
            return true;
        }
        return this.currFrom.weight + this.currTo.weight >= this.bestPath.getWeight();
    }

    @Override
    boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = this.pqOpenSetFrom.poll();
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, this.bestWeightMapFrom, this.ignoreExplorationFrom, this.outEdgeExplorer, false);
        ++this.visitedCountFrom;
        return true;
    }

    @Override
    boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = this.pqOpenSetTo.poll();
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, this.bestWeightMapTo, this.ignoreExplorationTo, this.inEdgeExplorer, true);
        ++this.visitedCountTo;
        return true;
    }

    private void fillEdges(AStar.AStarEntry currEdge, PriorityQueue<AStar.AStarEntry> prioQueueOpenSet, IntObjectMap<AStar.AStarEntry> bestWeightMap, IntHashSet ignoreExploration, EdgeExplorer explorer, boolean reverse) {
        int currNode = currEdge.adjNode;
        EdgeIterator iter = explorer.setBaseNode(currNode);
        while (iter.next()) {
            AStar.AStarEntry ase;
            double alreadyVisitedWeight;
            if (!this.accept(iter, currEdge.edge)) continue;
            int neighborNode = iter.getAdjNode();
            int traversalId = this.traversalMode.createTraversalId(iter, reverse);
            if (ignoreExploration.contains(traversalId) || Double.isInfinite(alreadyVisitedWeight = this.weighting.calcWeight(iter, reverse, currEdge.edge) + currEdge.getWeightOfVisitedPath()) || (ase = (AStar.AStarEntry)bestWeightMap.get(traversalId)) != null && !(ase.getWeightOfVisitedPath() > alreadyVisitedWeight)) continue;
            double currWeightToGoal = this.weightApprox.approximate(neighborNode, reverse);
            double estimationFullWeight = alreadyVisitedWeight + currWeightToGoal;
            if (ase == null) {
                ase = new AStar.AStarEntry(iter.getEdge(), neighborNode, estimationFullWeight, alreadyVisitedWeight);
                bestWeightMap.put(traversalId, (Object)ase);
            } else {
                prioQueueOpenSet.remove(ase);
                ase.edge = iter.getEdge();
                ase.weight = estimationFullWeight;
                ase.weightOfVisitedPath = alreadyVisitedWeight;
            }
            ase.parent = currEdge;
            prioQueueOpenSet.add(ase);
            if (!this.updateBestPath) continue;
            this.updateBestPath((EdgeIteratorState)iter, ase, traversalId);
        }
    }

    public void updateBestPath(EdgeIteratorState edgeState, AStar.AStarEntry entryCurrent, int currLoc) {
        AStar.AStarEntry entryOther = (AStar.AStarEntry)this.bestWeightMapOther.get(currLoc);
        if (entryOther == null) {
            return;
        }
        boolean reverse = this.bestWeightMapFrom == this.bestWeightMapOther;
        double newWeight = entryCurrent.weightOfVisitedPath + entryOther.weightOfVisitedPath;
        if (this.traversalMode.isEdgeBased()) {
            if (entryOther.edge != entryCurrent.edge) {
                throw new IllegalStateException("cannot happen for edge based execution of " + this.getName());
            }
            if (entryOther.adjNode != entryCurrent.adjNode) {
                entryCurrent = (AStar.AStarEntry)entryCurrent.parent;
                newWeight -= this.weighting.calcWeight(edgeState, reverse, -1);
            } else if (!this.traversalMode.hasUTurnSupport()) {
                return;
            }
        }
        if (newWeight < this.bestPath.getWeight()) {
            this.bestPath.setSwitchToFrom(reverse);
            this.bestPath.sptEntry = entryCurrent;
            this.bestPath.edgeTo = entryOther;
            this.bestPath.setWeight(newWeight);
        }
    }

    IntObjectMap<AStar.AStarEntry> getBestFromMap() {
        return this.bestWeightMapFrom;
    }

    IntObjectMap<AStar.AStarEntry> getBestToMap() {
        return this.bestWeightMapTo;
    }

    void setBestOtherMap(IntObjectMap<AStar.AStarEntry> other) {
        this.bestWeightMapOther = other;
    }

    void setFromDataStructures(AStarBidirection astar) {
        this.pqOpenSetFrom = astar.pqOpenSetFrom;
        this.bestWeightMapFrom = astar.bestWeightMapFrom;
        this.finishedFrom = astar.finishedFrom;
        this.currFrom = astar.currFrom;
        this.visitedCountFrom = astar.visitedCountFrom;
        this.ignoreExplorationFrom = astar.ignoreExplorationFrom;
        this.weightApprox.setFrom(astar.currFrom.adjNode);
    }

    void setToDataStructures(AStarBidirection astar) {
        this.pqOpenSetTo = astar.pqOpenSetTo;
        this.bestWeightMapTo = astar.bestWeightMapTo;
        this.finishedTo = astar.finishedTo;
        this.currTo = astar.currTo;
        this.visitedCountTo = astar.visitedCountTo;
        this.ignoreExplorationTo = astar.ignoreExplorationTo;
        this.weightApprox.setTo(astar.currTo.adjNode);
    }

    @Override
    public void afterHeuristicChange(boolean forward, boolean backward) {
        AStar.AStarEntry[] entries;
        if (forward && !this.pqOpenSetFrom.isEmpty()) {
            entries = this.pqOpenSetFrom.toArray(new AStar.AStarEntry[this.pqOpenSetFrom.size()]);
            this.pqOpenSetFrom.clear();
            for (AStar.AStarEntry value : entries) {
                value.weight = value.weightOfVisitedPath + this.weightApprox.approximate(value.adjNode, false);
                this.pqOpenSetFrom.add(value);
            }
        }
        if (backward && !this.pqOpenSetTo.isEmpty()) {
            entries = this.pqOpenSetTo.toArray(new AStar.AStarEntry[this.pqOpenSetTo.size()]);
            this.pqOpenSetTo.clear();
            for (AStar.AStarEntry value : entries) {
                value.weight = value.weightOfVisitedPath + this.weightApprox.approximate(value.adjNode, true);
                this.pqOpenSetTo.add(value);
            }
        }
    }

    @Override
    public String getName() {
        return "astarbi|" + this.weightApprox;
    }
}

