/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRoutingAlgorithm
implements RoutingAlgorithm {
    protected final Graph graph;
    protected final Weighting weighting;
    protected final FlagEncoder flagEncoder;
    protected final TraversalMode traversalMode;
    protected NodeAccess nodeAccess;
    protected EdgeExplorer inEdgeExplorer;
    protected EdgeExplorer outEdgeExplorer;
    protected int maxVisitedNodes = Integer.MAX_VALUE;
    private EdgeFilter additionalEdgeFilter;
    private boolean alreadyRun;

    public AbstractRoutingAlgorithm(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        this.weighting = weighting;
        this.flagEncoder = weighting.getFlagEncoder();
        this.traversalMode = traversalMode;
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.outEdgeExplorer = graph.createEdgeExplorer(new DefaultEdgeFilter(this.flagEncoder, false, true));
        this.inEdgeExplorer = graph.createEdgeExplorer(new DefaultEdgeFilter(this.flagEncoder, true, false));
    }

    @Override
    public void setMaxVisitedNodes(int numberOfNodes) {
        this.maxVisitedNodes = numberOfNodes;
    }

    public RoutingAlgorithm setEdgeFilter(EdgeFilter additionalEdgeFilter) {
        this.additionalEdgeFilter = additionalEdgeFilter;
        return this;
    }

    protected boolean accept(EdgeIterator iter, int prevOrNextEdgeId) {
        if (!this.traversalMode.hasUTurnSupport() && iter.getEdge() == prevOrNextEdgeId) {
            return false;
        }
        return this.additionalEdgeFilter == null || this.additionalEdgeFilter.accept(iter);
    }

    protected void updateBestPath(EdgeIteratorState edgeState, SPTEntry bestSPTEntry, int traversalId) {
    }

    protected void checkAlreadyRun() {
        if (this.alreadyRun) {
            throw new IllegalStateException("Create a new instance per call");
        }
        this.alreadyRun = true;
    }

    protected SPTEntry createSPTEntry(int node, double weight) {
        return new SPTEntry(-1, node, weight);
    }

    protected abstract boolean finished();

    protected abstract Path extractPath();

    @Override
    public List<Path> calcPaths(int from, int to) {
        return Collections.singletonList(this.calcPath(from, to));
    }

    protected Path createEmptyPath() {
        return new Path(this.graph, this.weighting);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getName() + "|" + this.weighting;
    }

    protected boolean isMaxVisitedNodesExceeded() {
        return this.maxVisitedNodes < this.getVisitedNodes();
    }
}

