/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareLandmarks
extends AbstractAlgoPreparation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrepareLandmarks.class);
    private final Graph graph;
    private final LandmarkStorage lms;
    private final Weighting weighting;
    private int defaultActiveLandmarks;

    public PrepareLandmarks(Directory dir, GraphHopperStorage graph, Weighting weighting, int landmarks, int activeLandmarks) {
        if (activeLandmarks > landmarks) {
            throw new IllegalArgumentException("Default value for active landmarks " + activeLandmarks + " should be less or equal to landmark count of " + landmarks);
        }
        this.graph = graph;
        this.defaultActiveLandmarks = activeLandmarks;
        this.weighting = weighting;
        this.lms = new LandmarkStorage(graph, dir, weighting, landmarks);
    }

    public PrepareLandmarks setLandmarkSuggestions(List<LandmarkSuggestion> landmarkSuggestions) {
        this.lms.setLandmarkSuggestions(landmarkSuggestions);
        return this;
    }

    public PrepareLandmarks setSpatialRuleLookup(SpatialRuleLookup ruleLookup) {
        this.lms.setSpatialRuleLookup(ruleLookup);
        return this;
    }

    public PrepareLandmarks setMaximumWeight(double maximumWeight) {
        this.lms.setMaximumWeight(maximumWeight);
        return this;
    }

    public void setLMSelectionWeighting(Weighting w) {
        this.lms.setLMSelectionWeighting(w);
    }

    public void setMinimumNodes(int nodes) {
        if (nodes < 2) {
            throw new IllegalArgumentException("minimum node count must be at least 2");
        }
        this.lms.setMinimumNodes(nodes);
    }

    public PrepareLandmarks setLogDetails(boolean logDetails) {
        this.lms.setLogDetails(logDetails);
        return this;
    }

    LandmarkStorage getLandmarkStorage() {
        return this.lms;
    }

    public int getSubnetworksWithLandmarks() {
        return this.lms.getSubnetworksWithLandmarks();
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    public boolean loadExisting() {
        return this.lms.loadExisting();
    }

    @Override
    public void doWork() {
        super.doWork();
        StopWatch sw = new StopWatch().start();
        LOGGER.info("Start calculating " + this.lms.getLandmarkCount() + " landmarks, default active lms:" + this.defaultActiveLandmarks + ", weighting:" + this.lms.getLmSelectionWeighting() + ", " + Helper.getMemInfo());
        this.lms.createLandmarks();
        this.lms.flush();
        LOGGER.info("Calculating landmarks for " + (this.lms.getSubnetworksWithLandmarks() - 1) + " subnetworks took:" + sw.stop().getSeconds() + " => " + this.lms.getLandmarksAsGeoJSON() + ", stored weights:" + this.lms.getLandmarkCount() + ", nodes:" + this.graph.getNodes() + ", " + Helper.getMemInfo());
    }

    public RoutingAlgorithm getDecoratedAlgorithm(Graph qGraph, RoutingAlgorithm algo, AlgorithmOptions opts) {
        int activeLM = Math.max(1, opts.getHints().getInt("lm.active_landmarks", this.defaultActiveLandmarks));
        if (algo instanceof AStar) {
            if (!this.lms.isInitialized()) {
                throw new IllegalStateException("Initalize landmark storage before creating algorithms");
            }
            double epsilon = opts.getHints().getDouble("astar.epsilon", 1.0);
            AStar astar = (AStar)algo;
            astar.setApproximation(new LMApproximator(qGraph, this.graph.getNodes(), this.lms, activeLM, this.lms.getFactor(), false).setEpsilon(epsilon));
            return algo;
        }
        if (algo instanceof AStarBidirection) {
            if (!this.lms.isInitialized()) {
                throw new IllegalStateException("Initalize landmark storage before creating algorithms");
            }
            double epsilon = opts.getHints().getDouble("astarbi.epsilon", 1.0);
            AStarBidirection astarbi = (AStarBidirection)algo;
            astarbi.setApproximation(new LMApproximator(qGraph, this.graph.getNodes(), this.lms, activeLM, this.lms.getFactor(), false).setEpsilon(epsilon));
            return algo;
        }
        if (algo instanceof AlternativeRoute) {
            if (!this.lms.isInitialized()) {
                throw new IllegalStateException("Initalize landmark storage before creating algorithms");
            }
            double epsilon = opts.getHints().getDouble("astarbi.epsilon", 1.0);
            AlternativeRoute altRoute = (AlternativeRoute)algo;
            altRoute.setApproximation(new LMApproximator(qGraph, this.graph.getNodes(), this.lms, activeLM, this.lms.getFactor(), false).setEpsilon(epsilon));
            altRoute.setMaxExplorationFactor(0.6);
        }
        return algo;
    }
}

