/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.template.ViaRoutingTemplate;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Collections;
import java.util.List;

public final class AlternativeRoutingTemplate
extends ViaRoutingTemplate {
    public AlternativeRoutingTemplate(GHRequest ghRequest, GHResponse ghRsp, LocationIndex locationIndex) {
        super(ghRequest, ghRsp, locationIndex);
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> points, FlagEncoder encoder) {
        if (points.size() > 2) {
            throw new IllegalArgumentException("Currently alternative routes work only with start and end point. You tried to use: " + points.size() + " points");
        }
        return super.lookup(points, encoder);
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory algoFactory, AlgorithmOptions algoOpts) {
        boolean withViaTurnPenalty = this.ghRequest.getHints().getBool("pass_through", false);
        if (withViaTurnPenalty) {
            throw new IllegalArgumentException("Alternative paths and pass_through at the same time is currently not supported");
        }
        return super.calcPaths(queryGraph, algoFactory, algoOpts);
    }

    @Override
    public boolean isReady(PathMerger pathMerger, Translation tr) {
        if (this.pathList.isEmpty()) {
            throw new RuntimeException("Empty paths for alternative route calculation not expected");
        }
        PointList wpList = this.getWaypoints();
        this.altResponse.setWaypoints(wpList);
        this.ghResponse.add(this.altResponse);
        pathMerger.doWork(this.altResponse, Collections.singletonList(this.pathList.get(0)), tr);
        for (int index = 1; index < this.pathList.size(); ++index) {
            PathWrapper tmpAltRsp = new PathWrapper();
            tmpAltRsp.setWaypoints(wpList);
            this.ghResponse.add(tmpAltRsp);
            pathMerger.doWork(tmpAltRsp, Collections.singletonList(this.pathList.get(index)), tr);
        }
        return true;
    }
}

