/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class CurvatureWeighting
extends PriorityWeighting {
    private final double minFactor;

    public CurvatureWeighting(FlagEncoder flagEncoder, PMap pMap) {
        super(flagEncoder, pMap);
        double minBendiness = 1.0;
        double maxPriority = 1.0;
        this.minFactor = minBendiness / Math.log(flagEncoder.getMaxSpeed()) / (0.5 + maxPriority);
    }

    @Override
    public double getMinWeight(double distance) {
        return this.minFactor * distance;
    }

    @Override
    public double calcWeight(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
        double priority = this.flagEncoder.getDouble(edge.getFlags(), 101);
        double bendiness = this.flagEncoder.getDouble(edge.getFlags(), 112);
        double speed = this.getRoadSpeed(edge, reverse);
        double roadDistance = edge.getDistance();
        double regularWeight = roadDistance / Math.log(speed);
        return bendiness * regularWeight / (0.5 + priority);
    }

    protected double getRoadSpeed(EdgeIteratorState edge, boolean reverse) {
        return reverse ? this.flagEncoder.getReverseSpeed(edge.getFlags()) : this.flagEncoder.getSpeed(edge.getFlags());
    }

    @Override
    public String getName() {
        return "curvature";
    }
}

