/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.matching.GPXExtension;
import com.graphhopper.util.EdgeIteratorState;
import java.util.List;

public class EdgeMatch {
    private final EdgeIteratorState edgeState;
    private final List<GPXExtension> gpxExtensions;

    public EdgeMatch(EdgeIteratorState edgeState, List<GPXExtension> gpxExtension) {
        this.edgeState = edgeState;
        if (edgeState == null) {
            throw new IllegalStateException("Cannot fetch null EdgeState");
        }
        this.gpxExtensions = gpxExtension;
        if (this.gpxExtensions == null) {
            throw new IllegalStateException("extension list cannot be null");
        }
    }

    public boolean isEmpty() {
        return this.gpxExtensions.isEmpty();
    }

    public EdgeIteratorState getEdgeState() {
        return this.edgeState;
    }

    public List<GPXExtension> getGpxExtensions() {
        return this.gpxExtensions;
    }

    public double getMinDistance() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No minimal distance for " + this.edgeState);
        }
        double min = Double.MAX_VALUE;
        for (GPXExtension gpxExt : this.gpxExtensions) {
            if (!(gpxExt.getQueryResult().getQueryDistance() < min)) continue;
            min = gpxExt.getQueryResult().getQueryDistance();
        }
        return min;
    }

    public String toString() {
        return "edge:" + this.edgeState + ", extensions:" + this.gpxExtensions;
    }
}

