/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.routing.Path;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.GPXEntry;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GPXFile {
    static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    static final String DATE_FORMAT_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final String DATE_FORMAT_Z_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final List<GPXEntry> entries;
    private boolean includeElevation = false;
    private InstructionList instructions;

    public GPXFile() {
        this.entries = new ArrayList<GPXEntry>();
    }

    public GPXFile(List<GPXEntry> entries) {
        this.entries = entries;
    }

    public GPXFile(MatchResult mr, InstructionList il) {
        this.instructions = il;
        this.entries = new ArrayList<GPXEntry>(mr.getEdgeMatches().size());
        long time = 0L;
        for (int emIndex = 0; emIndex < mr.getEdgeMatches().size(); ++emIndex) {
            EdgeMatch em = mr.getEdgeMatches().get(emIndex);
            PointList pl = em.getEdgeState().fetchWayGeometry(emIndex == 0 ? 3 : 2);
            if (pl.is3D()) {
                this.includeElevation = true;
            }
            for (int i = 0; i < pl.size(); ++i) {
                if (pl.is3D()) {
                    this.entries.add(new GPXEntry(pl.getLatitude(i), pl.getLongitude(i), pl.getElevation(i), time));
                    continue;
                }
                this.entries.add(new GPXEntry(pl.getLatitude(i), pl.getLongitude(i), time));
            }
        }
    }

    public List<GPXEntry> getEntries() {
        return this.entries;
    }

    public GPXFile doImport(String fileStr) {
        try {
            return this.doImport(new FileInputStream(fileStr), 20.0);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public GPXFile doImport(InputStream is, double defaultSpeed) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        SimpleDateFormat formatterZ = new SimpleDateFormat(DATE_FORMAT_Z);
        SimpleDateFormat formatterZMS = new SimpleDateFormat(DATE_FORMAT_Z_MS);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        DistancePlaneProjection distCalc = Helper.DIST_PLANE;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList nl = doc.getElementsByTagName("trkpt");
            double prevLat = 0.0;
            double prevLon = 0.0;
            long prevMillis = 0L;
            for (int index = 0; index < nl.getLength(); ++index) {
                NodeList eleNodes;
                Node n = nl.item(index);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                double lat = Double.parseDouble(e.getAttribute("lat"));
                double lon = Double.parseDouble(e.getAttribute("lon"));
                NodeList timeNodes = e.getElementsByTagName("time");
                long millis = prevMillis;
                if (timeNodes.getLength() == 0) {
                    if (index > 0) {
                        millis += Math.round(distCalc.calcDist(prevLat, prevLon, lat, lon) * 3600.0 / defaultSpeed);
                    }
                } else {
                    String text = timeNodes.item(0).getTextContent();
                    if (text.contains("Z")) {
                        try {
                            millis = formatterZ.parse(text).getTime();
                        }
                        catch (ParseException ex) {
                            millis = formatterZMS.parse(text).getTime();
                        }
                    } else {
                        millis = formatter.parse(GPXFile.revertTZHack(text)).getTime();
                    }
                }
                if ((eleNodes = e.getElementsByTagName("ele")).getLength() == 0) {
                    this.entries.add(new GPXEntry(lat, lon, millis));
                } else {
                    double ele = Double.parseDouble(eleNodes.item(0).getTextContent());
                    this.entries.add(new GPXEntry(lat, lon, ele, millis));
                }
                prevLat = lat;
                prevLon = lon;
                prevMillis = millis;
            }
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String revertTZHack(String str) {
        return str.substring(0, str.length() - 3) + str.substring(str.length() - 2);
    }

    public String toString() {
        return "entries " + this.entries.size() + ", " + this.entries;
    }

    public String createString() {
        long startTimeMillis = 0L;
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_Z);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        DecimalFormat decimalFormat = new DecimalFormat("#");
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        String header = "<?xml version='1.0' encoding='UTF-8' standalone='no' ?><gpx xmlns='http://www.topografix.com/GPX/1/1' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' creator='Graphhopper MapMatching " + Constants.VERSION + "' version='1.1' xmlns:gh='https://graphhopper.com/public/schema/gpx/1.1'>\n<metadata><copyright author=\"OpenStreetMap contributors\"/><link href='http://graphhopper.com'><text>GraphHopper GPX</text></link><time>" + formatter.format(startTimeMillis) + "</time></metadata>";
        StringBuilder gpxOutput = new StringBuilder(header);
        gpxOutput.append("\n<trk><name>").append("GraphHopper MapMatching").append("</name>");
        if (this.instructions != null && !this.instructions.isEmpty()) {
            gpxOutput.append("\n<rte>");
            Instruction nextInstr = null;
            for (Instruction currInstr : this.instructions) {
                if (null != nextInstr) {
                    this.instructions.createRteptBlock(gpxOutput, nextInstr, currInstr, decimalFormat);
                }
                nextInstr = currInstr;
            }
            this.instructions.createRteptBlock(gpxOutput, nextInstr, null, decimalFormat);
            gpxOutput.append("\n</rte>");
        }
        gpxOutput.append("<trkseg>");
        for (GPXEntry entry : this.entries) {
            gpxOutput.append("\n<trkpt lat='").append(Helper.round6((double)entry.getLat()));
            gpxOutput.append("' lon='").append(Helper.round6((double)entry.getLon())).append("'>");
            if (this.includeElevation) {
                gpxOutput.append("<ele>").append(Helper.round2((double)entry.getEle())).append("</ele>");
            }
            gpxOutput.append("<time>").append(formatter.format(startTimeMillis + entry.getTime())).append("</time>");
            gpxOutput.append("</trkpt>");
        }
        gpxOutput.append("</trkseg>");
        gpxOutput.append("</trk>");
        gpxOutput.append("</gpx>");
        return gpxOutput.toString().replaceAll("\\'", "\"");
    }

    public GPXFile doExport(String gpxFile) {
        GPXFile gPXFile;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(gpxFile));
            writer.append(this.createString());
            gPXFile = this;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Helper.close(writer);
                throw throwable;
            }
        }
        Helper.close((Closeable)writer);
        return gPXFile;
    }

    public static void write(Path path, String gpxFile, Translation translation) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(gpxFile));
            writer.append(path.calcInstructions(translation).createGPX());
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Helper.close(writer);
                throw throwable;
            }
        }
        Helper.close((Closeable)writer);
    }
}

