/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LocationIndexMatch
extends LocationIndexTree {
    private static final Comparator<QueryResult> QR_COMPARATOR = new Comparator<QueryResult>(){

        @Override
        public int compare(QueryResult o1, QueryResult o2) {
            return Double.compare(o1.getQueryDistance(), o2.getQueryDistance());
        }
    };
    private final LocationIndexTree index;

    public LocationIndexMatch(GraphHopperStorage graph, LocationIndexTree index) {
        super((Graph)graph, graph.getDirectory());
        this.index = index;
    }

    public List<QueryResult> findNClosest(final double queryLat, final double queryLon, EdgeFilter edgeFilter, double radius) {
        double returnAllResultsWithin = this.distCalc.calcNormalizedDist(radius);
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        GHIntHashSet set = new GHIntHashSet();
        for (int iteration = 0; iteration < 2; ++iteration) {
            this.index.findNetworkEntries(queryLat, queryLon, set, iteration);
            GHTBitSet exploredNodes = new GHTBitSet(new GHIntHashSet((IntContainer)set));
            EdgeExplorer explorer = this.graph.createEdgeExplorer(edgeFilter);
            set.forEach(new IntProcedure((GHBitSet)exploredNodes, edgeFilter, returnAllResultsWithin, queryResults, explorer){
                final /* synthetic */ GHBitSet val$exploredNodes;
                final /* synthetic */ EdgeFilter val$edgeFilter;
                final /* synthetic */ double val$returnAllResultsWithin;
                final /* synthetic */ List val$queryResults;
                final /* synthetic */ EdgeExplorer val$explorer;
                {
                    this.val$exploredNodes = gHBitSet;
                    this.val$edgeFilter = edgeFilter;
                    this.val$returnAllResultsWithin = d3;
                    this.val$queryResults = list;
                    this.val$explorer = edgeExplorer;
                }

                public void apply(int node) {
                    new LocationIndexTree.XFirstSearchCheck(queryLat, queryLon, this.val$exploredNodes, this.val$edgeFilter){

                        protected double getQueryDistance() {
                            return Double.MAX_VALUE;
                        }

                        protected boolean check(int node, double normedDist, int wayIndex, EdgeIteratorState edge, QueryResult.Position pos) {
                            if (normedDist < val$returnAllResultsWithin || val$queryResults.isEmpty() || ((QueryResult)val$queryResults.get(0)).getQueryDistance() > normedDist) {
                                int index = -1;
                                for (int qrIndex = 0; qrIndex < val$queryResults.size(); ++qrIndex) {
                                    QueryResult qr = (QueryResult)val$queryResults.get(qrIndex);
                                    if (qr.getQueryDistance() > val$returnAllResultsWithin) {
                                        index = qrIndex;
                                        break;
                                    }
                                    if (qr.getClosestEdge().getEdge() != edge.getEdge()) continue;
                                    if (qr.getQueryDistance() < normedDist) {
                                        return true;
                                    }
                                    index = qrIndex;
                                    break;
                                }
                                QueryResult qr = new QueryResult(queryLat, queryLon);
                                qr.setQueryDistance(normedDist);
                                qr.setClosestNode(node);
                                qr.setClosestEdge(edge.detach(false));
                                qr.setWayIndex(wayIndex);
                                qr.setSnappedPosition(pos);
                                if (index < 0) {
                                    val$queryResults.add(qr);
                                } else {
                                    val$queryResults.set(index, qr);
                                }
                            }
                            return true;
                        }
                    }.start(this.val$explorer, node);
                }
            });
        }
        Collections.sort(queryResults, QR_COMPARATOR);
        for (QueryResult qr : queryResults) {
            if (qr.isValid()) {
                qr.setQueryDistance(this.distCalc.calcDenormalizedDist(qr.getQueryDistance()));
                qr.calcSnappedPoint(this.distCalc);
                continue;
            }
            throw new IllegalStateException("Invalid QueryResult should not happen here: " + qr);
        }
        return queryResults;
    }
}

