/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.GraphHopper;
import com.graphhopper.PathWrapper;
import com.graphhopper.matching.GPXFile;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.GPXEntry;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.shapes.BBox;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMatchingMain {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) {
        new MapMatchingMain().start(CmdArgs.read((String[])args));
    }

    private void start(CmdArgs args) {
        String action = args.get("action", "").toLowerCase();
        args.put("graph.location", (Object)"./graph-cache");
        if (action.equals("import")) {
            String flagEncoders = args.get("vehicle", "").toLowerCase();
            if (flagEncoders.isEmpty()) {
                flagEncoders = args.get("vehicles", "car").toLowerCase();
            }
            args.put("graph.flag_encoders", (Object)flagEncoders);
            args.put("datareader.file", (Object)args.get("datasource", ""));
            if (!args.has("prepare.min_one_way_network_size")) {
                args.put("prepare.min_one_way_network_size", (Object)200);
            }
            this.logger.info("Configuration: " + args);
            GraphHopper hopper = new GraphHopperOSM().init(args);
            hopper.getCHFactoryDecorator().setEnabled(false);
            hopper.importOrLoad();
        } else if (action.equals("match")) {
            GraphHopper hopper = new GraphHopperOSM().init(args);
            hopper.getCHFactoryDecorator().setEnabled(false);
            this.logger.info("loading graph from cache");
            hopper.load("./graph-cache");
            FlagEncoder firstEncoder = (FlagEncoder)hopper.getEncodingManager().fetchEdgeEncoders().get(0);
            int gpsAccuracy = args.getInt("gps_accuracy", -1);
            if (gpsAccuracy < 0) {
                gpsAccuracy = args.getInt("gpx_accuracy", 40);
            }
            String instructions = args.get("instructions", "");
            this.logger.info("Setup lookup index. Accuracy filter is at " + gpsAccuracy + "m");
            AlgorithmOptions opts = AlgorithmOptions.start().algorithm("dijkstrabi").traversalMode(hopper.getTraversalMode()).weighting((Weighting)new FastestWeighting(firstEncoder)).maxVisitedNodes(args.getInt("max_visited_nodes", 1000)).hints((PMap)new HintsMap().put("weighting", (Object)"fastest").put("vehicle", (Object)firstEncoder.toString())).build();
            MapMatching mapMatching = new MapMatching(hopper, opts);
            mapMatching.setTransitionProbabilityBeta(args.getDouble("transition_probability_beta", 2.0));
            mapMatching.setMeasurementErrorSigma(gpsAccuracy);
            String gpxLocation = args.get("gpx", "");
            File[] files = this.getFiles(gpxLocation);
            this.logger.info("Now processing " + files.length + " files");
            StopWatch importSW = new StopWatch();
            StopWatch matchSW = new StopWatch();
            Translation tr = new TranslationMap().doImport().get(instructions);
            for (File gpxFile : files) {
                try {
                    InstructionList il;
                    importSW.start();
                    List<GPXEntry> inputGPXEntries = new GPXFile().doImport(gpxFile.getAbsolutePath()).getEntries();
                    importSW.stop();
                    matchSW.start();
                    MatchResult mr = mapMatching.doWork(inputGPXEntries);
                    matchSW.stop();
                    System.out.println(gpxFile);
                    System.out.println("\tmatches:\t" + mr.getEdgeMatches().size() + ", gps entries:" + inputGPXEntries.size());
                    System.out.println("\tgpx length:\t" + (float)mr.getGpxEntriesLength() + " vs " + (float)mr.getMatchLength());
                    System.out.println("\tgpx time:\t" + (float)mr.getGpxEntriesMillis() / 1000.0f + " vs " + (float)mr.getMatchMillis() / 1000.0f);
                    String outFile = gpxFile.getAbsolutePath() + ".res.gpx";
                    System.out.println("\texport results to:" + outFile);
                    if (instructions.isEmpty()) {
                        il = new InstructionList(null);
                    } else {
                        PathWrapper matchGHRsp = new PathWrapper();
                        Path path = mapMatching.calcPath(mr);
                        new PathMerger().doWork(matchGHRsp, Collections.singletonList(path), tr);
                        il = matchGHRsp.getInstructions();
                    }
                    new GPXFile(mr, il).doExport(outFile);
                }
                catch (Exception ex) {
                    importSW.stop();
                    matchSW.stop();
                    this.logger.error("Problem with file " + gpxFile + " Error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            System.out.println("gps import took:" + importSW.getSeconds() + "s, match took: " + matchSW.getSeconds());
        } else if (action.equals("getbounds")) {
            String gpxLocation = args.get("gpx", "");
            File[] files = this.getFiles(gpxLocation);
            BBox bbox = BBox.createInverse((boolean)false);
            for (File gpxFile : files) {
                List<GPXEntry> inputGPXEntries = new GPXFile().doImport(gpxFile.getAbsolutePath()).getEntries();
                for (GPXEntry entry : inputGPXEntries) {
                    bbox.update(entry.getLat(), entry.getLon());
                }
            }
            System.out.println("max bounds: " + bbox);
            if (bbox.maxLat - bbox.minLat < 0.1 && bbox.maxLon - bbox.minLon < 0.1) {
                double delta = 0.01;
                System.out.println("Get small areas via\nwget -O extract.osm 'http://overpass-api.de/api/map?bbox=" + (bbox.minLon - delta) + "," + (bbox.minLat - delta) + "," + (bbox.maxLon + delta) + "," + (bbox.maxLat + delta) + "'");
            }
        } else {
            System.out.println("Usage: Do an import once, then do the matching\n./map-matching action=import datasource=your.pbf\n./map-matching action=match gpx=your.gpx\n./map-matching action=match gpx=.*gpx\n\nOr start in-built matching web service\n./map-matching action=start-server\n\n");
        }
    }

    File[] getFiles(String gpxLocation) {
        if (gpxLocation.contains("*")) {
            String pattern;
            int lastIndex = gpxLocation.lastIndexOf(File.separator);
            File dir = new File(".");
            if (lastIndex >= 0) {
                dir = new File(gpxLocation.substring(0, lastIndex));
                pattern = gpxLocation.substring(lastIndex + 1);
            } else {
                pattern = gpxLocation;
            }
            return dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(pattern);
                }
            });
        }
        return new File[]{new File(gpxLocation)};
    }
}

