/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching.util;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.matching.LocationIndexMatch;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.GPXEntry;
import com.graphhopper.util.Helper;
import com.graphhopper.util.MiniPerfTest;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Measurement {
    private static final Logger logger = LoggerFactory.getLogger(Measurement.class);
    private final Map<String, String> properties = new TreeMap<String, String>();
    private long seed;
    private int count;
    private BBox bbox;
    private DistanceCalcEarth distCalc = new DistanceCalcEarth();

    public static void main(String[] strs) throws Exception {
        new Measurement().start(CmdArgs.read((String[])strs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(CmdArgs args) throws Exception {
        String graphLocation = args.get("graph.location", "");
        String propLocation = args.get("measurement.location", "");
        if (Helper.isEmpty((String)propLocation)) {
            throw new Exception("You must provide an output location via the 'measurement.location' argument");
        }
        this.seed = args.getLong("measurement.seed", 123L);
        this.count = args.getInt("measurement.count", 5000);
        GraphHopperOSM hopper = new GraphHopperOSM();
        hopper.init(args).forDesktop();
        hopper.getCHFactoryDecorator().setEnabled(true);
        hopper.getCHFactoryDecorator().setDisablingAllowed(true);
        hopper.importOrLoad();
        GraphHopperStorage graph = hopper.getGraphHopperStorage();
        this.bbox = graph.getBounds();
        LocationIndexMatch locationIndex = new LocationIndexMatch(graph, (LocationIndexTree)hopper.getLocationIndex());
        AlgorithmOptions algoOpts = AlgorithmOptions.start().maxVisitedNodes(Integer.MAX_VALUE).build();
        MapMatching mapMatching = new MapMatching((GraphHopper)hopper, algoOpts);
        StopWatch sw = new StopWatch().start();
        try {
            this.printLocationIndexMatchQuery(locationIndex);
            this.printTimeOfMapMatchQuery((GraphHopper)hopper, mapMatching);
            System.gc();
            logger.info("store into " + propLocation);
        }
        catch (Exception ex) {
            logger.error("Problem while measuring " + graphLocation, (Throwable)ex);
            this.put("error", ex.toString());
        }
        finally {
            this.put("measurement.count", this.count);
            this.put("measurement.seed", this.seed);
            this.put("measurement.time", sw.stop().getTime());
            System.gc();
            this.put("measurement.totalMB", Helper.getTotalMB());
            this.put("measurement.usedMB", Helper.getUsedMB());
            try {
                this.store(new FileWriter(propLocation));
            }
            catch (IOException ex) {
                logger.error("Problem while storing properties " + graphLocation + ", " + propLocation, (Throwable)ex);
            }
        }
    }

    private void printLocationIndexMatchQuery(final LocationIndexMatch idx) {
        final double latDelta = this.bbox.maxLat - this.bbox.minLat;
        final double lonDelta = this.bbox.maxLon - this.bbox.minLon;
        final Random rand = new Random(this.seed);
        MiniPerfTest miniPerf = new MiniPerfTest(){

            public int doCalc(boolean warmup, int run) {
                double lat = rand.nextDouble() * latDelta + ((Measurement)Measurement.this).bbox.minLat;
                double lon = rand.nextDouble() * lonDelta + ((Measurement)Measurement.this).bbox.minLon;
                int val = idx.findNClosest(lat, lon, EdgeFilter.ALL_EDGES, rand.nextDouble() * 500.0).size();
                return val;
            }
        }.setIterations(this.count).start();
        this.print("location_index_match", miniPerf);
    }

    private void printTimeOfMapMatchQuery(final GraphHopper hopper, final MapMatching mapMatching) {
        final double latDelta = this.bbox.maxLat - this.bbox.minLat;
        final double lonDelta = this.bbox.maxLon - this.bbox.minLon;
        final Random rand = new Random(this.seed);
        int n = this.count;
        if (n > 100) {
            logger.warn("map matching query tests take a while, so we'll only do 100 iterations (instead of " + this.count + ")");
            n = 100;
        }
        MiniPerfTest miniPerf = new MiniPerfTest(){

            public int doCalc(boolean warmup, int run) {
                boolean foundPath = false;
                while (!foundPath) {
                    double lon1;
                    double lat1;
                    double lon0;
                    double lat0 = ((Measurement)Measurement.this).bbox.minLat + rand.nextDouble() * latDelta;
                    GHResponse r = hopper.route(new GHRequest(lat0, lon0 = ((Measurement)Measurement.this).bbox.minLon + rand.nextDouble() * lonDelta, lat1 = ((Measurement)Measurement.this).bbox.minLat + rand.nextDouble() * latDelta, lon1 = ((Measurement)Measurement.this).bbox.minLon + rand.nextDouble() * lonDelta));
                    if (r.hasErrors()) continue;
                    foundPath = true;
                    long time = 0L;
                    double sampleProportion = rand.nextDouble();
                    GHPoint prev = null;
                    ArrayList<GPXEntry> mock = new ArrayList<GPXEntry>();
                    PointList points = r.getBest().getPoints();
                    for (GHPoint p : points) {
                        if (null != prev && rand.nextDouble() < sampleProportion) {
                            double dx = Measurement.this.distCalc.calcDist(prev.lat, prev.lon, p.lat, p.lon);
                            double speedKPH = rand.nextDouble() * 100.0;
                            double dt = dx / 1000.0 / speedKPH * 3600000.0;
                            GHPoint randomised = Measurement.this.distCalc.projectCoordinate(p.lat, p.lon, 20.0 * rand.nextDouble(), 360.0 * rand.nextDouble());
                            mock.add(new GPXEntry(randomised, time += (long)dt));
                        }
                        prev = p;
                    }
                    if (mock.size() > 2) {
                        MatchResult match = mapMatching.doWork(mock);
                        return match.getEdgeMatches().size();
                    }
                    foundPath = false;
                }
                return 0;
            }
        }.setIterations(n).start();
        this.print("map_match", miniPerf);
    }

    void print(String prefix, MiniPerfTest perf) {
        logger.info(prefix + ": " + perf.getReport());
        this.put(prefix + ".sum", perf.getSum());
        this.put(prefix + ".min", perf.getMin());
        this.put(prefix + ".mean", perf.getMean());
        this.put(prefix + ".max", perf.getMax());
    }

    void put(String key, Object val) {
        this.properties.put(key, "" + val);
    }

    private void store(FileWriter fileWriter) throws IOException {
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            fileWriter.append(e.getKey());
            fileWriter.append("=");
            fileWriter.append(e.getValue());
            fileWriter.append("\n");
        }
        fileWriter.flush();
    }
}

