/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching.util;

import com.bmw.hmm.Transition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TimeStep<S, O, D> {
    public final O observation;
    public final Collection<S> candidates;
    public final Map<S, Double> emissionLogProbabilities = new HashMap<S, Double>();
    public final Map<Transition<S>, Double> transitionLogProbabilities = new HashMap<Transition<S>, Double>();
    public final Map<Transition<S>, D> roadPaths = new HashMap<Transition<S>, D>();

    public TimeStep(O observation, Collection<S> candidates) {
        if (observation == null || candidates == null) {
            throw new NullPointerException("observation and candidates must not be null.");
        }
        this.observation = observation;
        this.candidates = candidates;
    }

    public void addEmissionLogProbability(S candidate, double emissionLogProbability) {
        if (this.emissionLogProbabilities.containsKey(candidate)) {
            throw new IllegalArgumentException("Candidate has already been added.");
        }
        this.emissionLogProbabilities.put(candidate, emissionLogProbability);
    }

    public void addTransitionLogProbability(S fromPosition, S toPosition, double transitionLogProbability) {
        Transition transition = new Transition(fromPosition, toPosition);
        if (this.transitionLogProbabilities.containsKey(transition)) {
            throw new IllegalArgumentException("Transition has already been added.");
        }
        this.transitionLogProbabilities.put(transition, transitionLogProbability);
    }

    public void addRoadPath(S fromPosition, S toPosition, D roadPath) {
        Transition transition = new Transition(fromPosition, toPosition);
        if (this.roadPaths.containsKey(transition)) {
            throw new IllegalArgumentException("Transition has already been added.");
        }
        this.roadPaths.put(transition, roadPath);
    }
}

