/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.bmw.hmm.SequenceState;
import com.bmw.hmm.ViterbiAlgorithm;
import com.graphhopper.GraphHopper;
import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.GPXExtension;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.util.HmmProbabilities;
import com.graphhopper.matching.util.TimeStep;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.VirtualEdgeIteratorState;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.LevelEdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GPXEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMatching {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private double uTurnDistancePenalty;
    private final Graph routingGraph;
    private final LocationIndexTree locationIndex;
    private double measurementErrorSigma = 50.0;
    private double transitionProbabilityBeta = 2.0;
    private final int maxVisitedNodes;
    private final int nodeCount;
    private DistanceCalc distanceCalc = new DistancePlaneProjection();
    private final Weighting weighting;
    private final boolean ch;

    public MapMatching(GraphHopper graphHopper, AlgorithmOptions algoOptions) {
        String vehicle;
        double PENALTY_CONVERSION_VELOCITY = 5.0;
        double headingTimePenalty = algoOptions.getHints().getDouble("heading_penalty", 300.0);
        this.uTurnDistancePenalty = headingTimePenalty * 5.0;
        this.locationIndex = (LocationIndexTree)graphHopper.getLocationIndex();
        HintsMap hints = new HintsMap();
        for (Map.Entry entry : algoOptions.getHints().toMap().entrySet()) {
            hints.put((String)entry.getKey(), entry.getValue());
        }
        if (!hints.has("ch.disable")) {
            hints.put("ch.disable", (Object)true);
            if (!graphHopper.getCHFactoryDecorator().isDisablingAllowed()) {
                throw new IllegalArgumentException("Cannot disable CH. Not allowed on server side");
            }
        }
        if ((vehicle = hints.getVehicle()).isEmpty()) {
            vehicle = algoOptions.hasWeighting() ? algoOptions.getWeighting().getFlagEncoder().toString() : ((FlagEncoder)graphHopper.getEncodingManager().fetchEdgeEncoders().get(0)).toString();
            hints.setVehicle(vehicle);
        }
        this.weighting = new FastestWeighting(graphHopper.getEncodingManager().getEncoder(vehicle), algoOptions.getHints());
        RoutingAlgorithmFactory routingAlgorithmFactory = graphHopper.getAlgorithmFactory(hints);
        if (routingAlgorithmFactory instanceof PrepareContractionHierarchies) {
            this.ch = true;
            this.routingGraph = graphHopper.getGraphHopperStorage().getGraph(CHGraph.class, ((PrepareContractionHierarchies)routingAlgorithmFactory).getWeighting());
        } else {
            this.ch = false;
            this.routingGraph = graphHopper.getGraphHopperStorage();
        }
        this.nodeCount = this.routingGraph.getNodes();
        this.maxVisitedNodes = algoOptions.getMaxVisitedNodes();
    }

    public void setDistanceCalc(DistanceCalc distanceCalc) {
        this.distanceCalc = distanceCalc;
    }

    public void setTransitionProbabilityBeta(double transitionProbabilityBeta) {
        this.transitionProbabilityBeta = transitionProbabilityBeta;
    }

    public void setMeasurementErrorSigma(double measurementErrorSigma) {
        this.measurementErrorSigma = measurementErrorSigma;
    }

    public MatchResult doWork(List<GPXEntry> gpxList) {
        List<GPXEntry> filteredGPXEntries = this.filterGPXEntries(gpxList);
        List<Collection<QueryResult>> queriesPerEntry = this.lookupGPXEntries(filteredGPXEntries, (EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)this.weighting.getFlagEncoder()));
        QueryGraph queryGraph = new QueryGraph(this.routingGraph).setUseEdgeExplorerCache(true);
        ArrayList<QueryResult> allQueryResults = new ArrayList<QueryResult>();
        for (Collection<QueryResult> collection : queriesPerEntry) {
            allQueryResults.addAll(collection);
        }
        queryGraph.lookup(allQueryResults);
        queriesPerEntry = this.deduplicateQueryResultsByClosestNode(queriesPerEntry);
        this.logger.debug("================= Query results =================");
        int i = 1;
        for (Collection<QueryResult> collection : queriesPerEntry) {
            this.logger.debug("Query results for GPX entry {}", (Object)i++);
            for (QueryResult queryResult : collection) {
                this.logger.debug("Node id: {}, virtual: {}, snapped on: {}, pos: {},{}, query distance: {}", new Object[]{queryResult.getClosestNode(), this.isVirtualNode(queryResult.getClosestNode()), queryResult.getSnappedPosition(), queryResult.getSnappedPoint().getLat(), queryResult.getSnappedPoint().getLon(), queryResult.getQueryDistance()});
            }
        }
        List<TimeStep<GPXExtension, GPXEntry, Path>> list = this.createTimeSteps(filteredGPXEntries, queriesPerEntry, queryGraph);
        this.logger.debug("=============== Time steps ===============");
        i = 1;
        for (TimeStep<GPXExtension, GPXEntry, Path> timeStep : list) {
            this.logger.debug("Candidates for time step {}", (Object)i++);
            for (GPXExtension candidate : timeStep.candidates) {
                this.logger.debug(candidate.toString());
            }
        }
        List<SequenceState<GPXExtension, GPXEntry, Path>> list2 = this.computeViterbiSequence(list, gpxList.size(), queryGraph);
        this.logger.debug("=============== Viterbi results =============== ");
        i = 1;
        for (SequenceState<GPXExtension, GPXEntry, Path> sequenceState : list2) {
            this.logger.debug("{}: {}, path: {}", new Object[]{i, sequenceState.state, sequenceState.transitionDescriptor != null ? ((Path)sequenceState.transitionDescriptor).calcEdges() : null});
            ++i;
        }
        EdgeExplorer edgeExplorer = queryGraph.createEdgeExplorer((EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)this.weighting.getFlagEncoder()));
        Map<String, EdgeIteratorState> map = this.createVirtualEdgesMap(queriesPerEntry, edgeExplorer);
        MatchResult matchResult = this.computeMatchResult(list2, map, gpxList, queryGraph);
        this.logger.debug("=============== Matched real edges =============== ");
        i = 1;
        for (EdgeMatch em : matchResult.getEdgeMatches()) {
            this.logger.debug("{}: {}", (Object)i, (Object)em.getEdgeState());
            ++i;
        }
        return matchResult;
    }

    private List<GPXEntry> filterGPXEntries(List<GPXEntry> gpxList) {
        ArrayList<GPXEntry> filtered = new ArrayList<GPXEntry>();
        GPXEntry prevEntry = null;
        int last = gpxList.size() - 1;
        for (int i = 0; i <= last; ++i) {
            GPXEntry gpxEntry = gpxList.get(i);
            if (i == 0 || i == last || this.distanceCalc.calcDist(prevEntry.getLat(), prevEntry.getLon(), gpxEntry.getLat(), gpxEntry.getLon()) > 2.0 * this.measurementErrorSigma) {
                filtered.add(gpxEntry);
                prevEntry = gpxEntry;
                continue;
            }
            this.logger.debug("Filter out GPX entry: {}", (Object)(i + 1));
        }
        return filtered;
    }

    private List<Collection<QueryResult>> lookupGPXEntries(List<GPXEntry> gpxList, EdgeFilter edgeFilter) {
        ArrayList<Collection<QueryResult>> gpxEntryLocations = new ArrayList<Collection<QueryResult>>();
        for (GPXEntry gpxEntry : gpxList) {
            List queryResults = this.locationIndex.findNClosest(gpxEntry.lat, gpxEntry.lon, edgeFilter, this.measurementErrorSigma);
            gpxEntryLocations.add(queryResults);
        }
        return gpxEntryLocations;
    }

    private List<Collection<QueryResult>> deduplicateQueryResultsByClosestNode(List<Collection<QueryResult>> queriesPerEntry) {
        ArrayList<Collection<QueryResult>> result = new ArrayList<Collection<QueryResult>>(queriesPerEntry.size());
        for (Collection<QueryResult> queryResults : queriesPerEntry) {
            HashMap<Integer, QueryResult> dedupedQueryResults = new HashMap<Integer, QueryResult>();
            for (QueryResult qr : queryResults) {
                dedupedQueryResults.put(qr.getClosestNode(), qr);
            }
            result.add(dedupedQueryResults.values());
        }
        return result;
    }

    private List<TimeStep<GPXExtension, GPXEntry, Path>> createTimeSteps(List<GPXEntry> filteredGPXEntries, List<Collection<QueryResult>> queriesPerEntry, QueryGraph queryGraph) {
        int n = filteredGPXEntries.size();
        if (queriesPerEntry.size() != n) {
            throw new IllegalArgumentException("filteredGPXEntries and queriesPerEntry must have same size.");
        }
        ArrayList<TimeStep<GPXExtension, GPXEntry, Path>> timeSteps = new ArrayList<TimeStep<GPXExtension, GPXEntry, Path>>();
        for (int i = 0; i < n; ++i) {
            GPXEntry gpxEntry = filteredGPXEntries.get(i);
            Collection<QueryResult> queryResults = queriesPerEntry.get(i);
            ArrayList<GPXExtension> candidates = new ArrayList<GPXExtension>();
            for (QueryResult qr : queryResults) {
                int closestNode = qr.getClosestNode();
                if (queryGraph.isVirtualNode(closestNode)) {
                    ArrayList<VirtualEdgeIteratorState> virtualEdges = new ArrayList<VirtualEdgeIteratorState>();
                    EdgeIterator iter = queryGraph.createEdgeExplorer().setBaseNode(closestNode);
                    while (iter.next()) {
                        if (!queryGraph.isVirtualEdge(iter.getEdge())) {
                            throw new RuntimeException("Virtual nodes must only have virtual edges to adjacent nodes.");
                        }
                        virtualEdges.add((VirtualEdgeIteratorState)queryGraph.getEdgeIteratorState(iter.getEdge(), iter.getAdjNode()));
                    }
                    if (virtualEdges.size() != 2) {
                        throw new RuntimeException("Each virtual node must have exactly 2 virtual edges (reverse virtual edges are not returned by the EdgeIterator");
                    }
                    VirtualEdgeIteratorState e1 = (VirtualEdgeIteratorState)virtualEdges.get(0);
                    VirtualEdgeIteratorState e2 = (VirtualEdgeIteratorState)virtualEdges.get(1);
                    for (int j = 0; j < 2; ++j) {
                        VirtualEdgeIteratorState incomingVirtualEdge = j == 0 ? e1 : e2;
                        VirtualEdgeIteratorState outgoingVirtualEdge = j == 0 ? e2 : e1;
                        QueryResult vqr = new QueryResult(qr.getQueryPoint().lat, qr.getQueryPoint().lon);
                        vqr.setQueryDistance(qr.getQueryDistance());
                        vqr.setClosestNode(qr.getClosestNode());
                        vqr.setWayIndex(qr.getWayIndex());
                        vqr.setSnappedPosition(qr.getSnappedPosition());
                        vqr.setClosestEdge(qr.getClosestEdge());
                        vqr.calcSnappedPoint(this.distanceCalc);
                        GPXExtension candidate = new GPXExtension(gpxEntry, vqr, incomingVirtualEdge, outgoingVirtualEdge);
                        candidates.add(candidate);
                    }
                    continue;
                }
                GPXExtension candidate = new GPXExtension(gpxEntry, qr);
                candidates.add(candidate);
            }
            TimeStep timeStep = new TimeStep(gpxEntry, candidates);
            timeSteps.add(timeStep);
        }
        return timeSteps;
    }

    private List<SequenceState<GPXExtension, GPXEntry, Path>> computeViterbiSequence(List<TimeStep<GPXExtension, GPXEntry, Path>> timeSteps, int originalGpxEntriesCount, QueryGraph queryGraph) {
        HmmProbabilities probabilities = new HmmProbabilities(this.measurementErrorSigma, this.transitionProbabilityBeta);
        ViterbiAlgorithm viterbi = new ViterbiAlgorithm();
        this.logger.debug("\n=============== Paths ===============");
        int timeStepCounter = 0;
        TimeStep<GPXExtension, GPXEntry, Path> prevTimeStep = null;
        int i = 1;
        for (TimeStep<GPXExtension, GPXEntry, Path> timeStep : timeSteps) {
            this.logger.debug("\nPaths to time step {}", (Object)i++);
            this.computeEmissionProbabilities(timeStep, probabilities);
            if (prevTimeStep == null) {
                viterbi.startWithInitialObservation(timeStep.observation, timeStep.candidates, timeStep.emissionLogProbabilities);
            } else {
                this.computeTransitionProbabilities(prevTimeStep, timeStep, probabilities, queryGraph);
                viterbi.nextStep(timeStep.observation, timeStep.candidates, timeStep.emissionLogProbabilities, timeStep.transitionLogProbabilities, timeStep.roadPaths);
            }
            if (viterbi.isBroken()) {
                String likelyReasonStr = "";
                if (prevTimeStep != null) {
                    GPXEntry prevGPXE = (GPXEntry)prevTimeStep.observation;
                    GPXEntry gpxe = (GPXEntry)timeStep.observation;
                    double dist = this.distanceCalc.calcDist(prevGPXE.lat, prevGPXE.lon, gpxe.lat, gpxe.lon);
                    if (dist > 2000.0) {
                        likelyReasonStr = "Too long distance to previous measurement? " + Math.round(dist) + "m, ";
                    }
                }
                throw new IllegalArgumentException("Sequence is broken for submitted track at time step " + timeStepCounter + " (" + originalGpxEntriesCount + " points). " + likelyReasonStr + "observation:" + timeStep.observation + ", " + timeStep.candidates.size() + " candidates: " + this.getSnappedCandidates(timeStep.candidates) + ". If a match is expected consider increasing max_visited_nodes.");
            }
            ++timeStepCounter;
            prevTimeStep = timeStep;
        }
        return viterbi.computeMostLikelySequence();
    }

    private void computeEmissionProbabilities(TimeStep<GPXExtension, GPXEntry, Path> timeStep, HmmProbabilities probabilities) {
        for (GPXExtension candidate : timeStep.candidates) {
            double distance = candidate.getQueryResult().getQueryDistance();
            timeStep.addEmissionLogProbability(candidate, probabilities.emissionLogProbability(distance));
        }
    }

    private void computeTransitionProbabilities(TimeStep<GPXExtension, GPXEntry, Path> prevTimeStep, TimeStep<GPXExtension, GPXEntry, Path> timeStep, HmmProbabilities probabilities, QueryGraph queryGraph) {
        double linearDistance = this.distanceCalc.calcDist(((GPXEntry)prevTimeStep.observation).lat, ((GPXEntry)prevTimeStep.observation).lon, ((GPXEntry)timeStep.observation).lat, ((GPXEntry)timeStep.observation).lon);
        double timeDiff = (double)(((GPXEntry)timeStep.observation).getTime() - ((GPXEntry)prevTimeStep.observation).getTime()) / 1000.0;
        this.logger.debug("Time difference: {} s", (Object)timeDiff);
        for (GPXExtension from : prevTimeStep.candidates) {
            for (GPXExtension to : timeStep.candidates) {
                Object router;
                if (from.isOnDirectedEdge()) {
                    queryGraph.unfavorVirtualEdgePair(from.getQueryResult().getClosestNode(), from.getIncomingVirtualEdge().getEdge());
                }
                if (to.isOnDirectedEdge()) {
                    queryGraph.unfavorVirtualEdgePair(to.getQueryResult().getClosestNode(), to.getOutgoingVirtualEdge().getEdge());
                }
                if (this.ch) {
                    router = new DijkstraBidirectionCH((Graph)queryGraph, (Weighting)new PreparationWeighting(this.weighting), TraversalMode.NODE_BASED){

                        protected void initCollections(int size) {
                            super.initCollections(50);
                        }
                    };
                    ((DijkstraBidirectionCH)router).setEdgeFilter((EdgeFilter)new LevelEdgeFilter((CHGraph)this.routingGraph));
                    router.setMaxVisitedNodes(this.maxVisitedNodes);
                } else {
                    router = new DijkstraBidirectionRef((Graph)queryGraph, this.weighting, TraversalMode.NODE_BASED){

                        protected void initCollections(int size) {
                            super.initCollections(50);
                        }
                    };
                    router.setMaxVisitedNodes(this.maxVisitedNodes);
                }
                Path path = router.calcPath(from.getQueryResult().getClosestNode(), to.getQueryResult().getClosestNode());
                if (path.isFound()) {
                    timeStep.addRoadPath(from, to, path);
                    double penalizedPathDistance = this.penalizedPathDistance(path, queryGraph.getUnfavoredVirtualEdges());
                    this.logger.debug("Path from: {}, to: {}, penalized path length: {}", new Object[]{from, to, penalizedPathDistance});
                    double transitionLogProbability = probabilities.transitionLogProbability(penalizedPathDistance, linearDistance);
                    timeStep.addTransitionLogProbability(from, to, transitionLogProbability);
                } else {
                    this.logger.debug("No path found for from: {}, to: {}", (Object)from, (Object)to);
                }
                queryGraph.clearUnfavoredStatus();
            }
        }
    }

    private double penalizedPathDistance(Path path, Set<EdgeIteratorState> penalizedVirtualEdges) {
        double totalPenalty = 0.0;
        List edges = path.calcEdges();
        if (!edges.isEmpty() && penalizedVirtualEdges.contains(edges.get(0))) {
            totalPenalty += this.uTurnDistancePenalty;
        }
        if (edges.size() > 1 && penalizedVirtualEdges.contains(edges.get(edges.size() - 1))) {
            totalPenalty += this.uTurnDistancePenalty;
        }
        return path.getDistance() + totalPenalty;
    }

    private MatchResult computeMatchResult(List<SequenceState<GPXExtension, GPXEntry, Path>> seq, Map<String, EdgeIteratorState> virtualEdgesMap, List<GPXEntry> gpxList, QueryGraph queryGraph) {
        double distance = 0.0;
        long time = 0L;
        for (SequenceState<GPXExtension, GPXEntry, Path> sequenceState : seq) {
            if (sequenceState.transitionDescriptor == null) continue;
            distance += ((Path)sequenceState.transitionDescriptor).getDistance();
            time += ((Path)sequenceState.transitionDescriptor).getTime();
        }
        ArrayList<EdgeIteratorState> edges = new ArrayList<EdgeIteratorState>();
        for (SequenceState<GPXExtension, GPXEntry, Path> sequenceState : seq) {
            if (sequenceState.transitionDescriptor == null) continue;
            edges.addAll(((Path)sequenceState.transitionDescriptor).calcEdges());
        }
        MapMatchedPath mapMatchedPath = new MapMatchedPath(queryGraph.getBaseGraph(), this.weighting, edges);
        List<EdgeMatch> list = this.computeEdgeMatches(seq, virtualEdgesMap);
        MatchResult matchResult = new MatchResult(list);
        matchResult.setMergedPath(mapMatchedPath);
        matchResult.setMatchMillis(time);
        matchResult.setMatchLength(distance);
        matchResult.setGPXEntriesMillis(this.durationMillis(gpxList));
        matchResult.setGPXEntriesLength(this.gpxLength(gpxList));
        return matchResult;
    }

    private List<EdgeMatch> computeEdgeMatches(List<SequenceState<GPXExtension, GPXEntry, Path>> seq, Map<String, EdgeIteratorState> virtualEdgesMap) {
        ArrayList<EdgeMatch> edgeMatches = new ArrayList<EdgeMatch>();
        ArrayList<GPXExtension> states = new ArrayList<GPXExtension>();
        EdgeIteratorState currentDirectedRealEdge = null;
        for (SequenceState<GPXExtension, GPXEntry, Path> transitionAndState : seq) {
            if (transitionAndState.transitionDescriptor != null) {
                for (EdgeIteratorState edge : ((Path)transitionAndState.transitionDescriptor).calcEdges()) {
                    EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(virtualEdgesMap, edge);
                    if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                        EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                        edgeMatches.add(edgeMatch);
                        states = new ArrayList();
                    }
                    currentDirectedRealEdge = newDirectedRealEdge;
                }
            }
            if (((GPXExtension)transitionAndState.state).isOnDirectedEdge()) {
                EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(virtualEdgesMap, ((GPXExtension)transitionAndState.state).getOutgoingVirtualEdge());
                if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                    EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                    edgeMatches.add(edgeMatch);
                    states = new ArrayList();
                }
                currentDirectedRealEdge = newDirectedRealEdge;
            }
            states.add((GPXExtension)transitionAndState.state);
        }
        if (currentDirectedRealEdge != null) {
            EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
            edgeMatches.add(edgeMatch);
        }
        return edgeMatches;
    }

    private double gpxLength(List<GPXEntry> gpxList) {
        if (gpxList.isEmpty()) {
            return 0.0;
        }
        double gpxLength = 0.0;
        GPXEntry prevEntry = gpxList.get(0);
        for (int i = 1; i < gpxList.size(); ++i) {
            GPXEntry entry = gpxList.get(i);
            gpxLength += this.distanceCalc.calcDist(prevEntry.lat, prevEntry.lon, entry.lat, entry.lon);
            prevEntry = entry;
        }
        return gpxLength;
    }

    private long durationMillis(List<GPXEntry> gpxList) {
        if (gpxList.isEmpty()) {
            return 0L;
        }
        return gpxList.get(gpxList.size() - 1).getTime() - gpxList.get(0).getTime();
    }

    private boolean equalEdges(EdgeIteratorState edge1, EdgeIteratorState edge2) {
        return edge1.getEdge() == edge2.getEdge() && edge1.getBaseNode() == edge2.getBaseNode() && edge1.getAdjNode() == edge2.getAdjNode();
    }

    private EdgeIteratorState resolveToRealEdge(Map<String, EdgeIteratorState> virtualEdgesMap, EdgeIteratorState edgeIteratorState) {
        if (this.isVirtualNode(edgeIteratorState.getBaseNode()) || this.isVirtualNode(edgeIteratorState.getAdjNode())) {
            return virtualEdgesMap.get(this.virtualEdgesMapKey(edgeIteratorState));
        }
        return edgeIteratorState;
    }

    private boolean isVirtualNode(int node) {
        return node >= this.nodeCount;
    }

    private Map<String, EdgeIteratorState> createVirtualEdgesMap(List<Collection<QueryResult>> queriesPerEntry, EdgeExplorer explorer) {
        HashMap<String, EdgeIteratorState> virtualEdgesMap = new HashMap<String, EdgeIteratorState>();
        for (Collection<QueryResult> queryResults : queriesPerEntry) {
            for (QueryResult qr : queryResults) {
                if (!this.isVirtualNode(qr.getClosestNode())) continue;
                EdgeIterator iter = explorer.setBaseNode(qr.getClosestNode());
                while (iter.next()) {
                    int node = this.traverseToClosestRealAdj(explorer, (EdgeIteratorState)iter);
                    if (node == qr.getClosestEdge().getAdjNode()) {
                        virtualEdgesMap.put(this.virtualEdgesMapKey((EdgeIteratorState)iter), qr.getClosestEdge().detach(false));
                        virtualEdgesMap.put(this.reverseVirtualEdgesMapKey((EdgeIteratorState)iter), qr.getClosestEdge().detach(true));
                        continue;
                    }
                    if (node == qr.getClosestEdge().getBaseNode()) {
                        virtualEdgesMap.put(this.virtualEdgesMapKey((EdgeIteratorState)iter), qr.getClosestEdge().detach(true));
                        virtualEdgesMap.put(this.reverseVirtualEdgesMapKey((EdgeIteratorState)iter), qr.getClosestEdge().detach(false));
                        continue;
                    }
                    throw new RuntimeException();
                }
            }
        }
        return virtualEdgesMap;
    }

    private String virtualEdgesMapKey(EdgeIteratorState iter) {
        return iter.getBaseNode() + "-" + iter.getEdge() + "-" + iter.getAdjNode();
    }

    private String reverseVirtualEdgesMapKey(EdgeIteratorState iter) {
        return iter.getAdjNode() + "-" + iter.getEdge() + "-" + iter.getBaseNode();
    }

    private int traverseToClosestRealAdj(EdgeExplorer explorer, EdgeIteratorState edge) {
        if (!this.isVirtualNode(edge.getAdjNode())) {
            return edge.getAdjNode();
        }
        EdgeIterator iter = explorer.setBaseNode(edge.getAdjNode());
        while (iter.next()) {
            if (iter.getAdjNode() == edge.getBaseNode()) continue;
            return this.traverseToClosestRealAdj(explorer, (EdgeIteratorState)iter);
        }
        throw new IllegalStateException("Cannot find adjacent edge " + edge);
    }

    private String getSnappedCandidates(Collection<GPXExtension> candidates) {
        String str = "";
        for (GPXExtension gpxe : candidates) {
            if (!str.isEmpty()) {
                str = str + ", ";
            }
            str = str + "distance: " + gpxe.getQueryResult().getQueryDistance() + " to " + gpxe.getQueryResult().getSnappedPoint();
        }
        return "[" + str + "]";
    }

    private static class MapMatchedPath
    extends Path {
        MapMatchedPath(Graph graph, Weighting weighting, List<EdgeIteratorState> edges) {
            super(graph, weighting);
            int prevEdge = -1;
            for (EdgeIteratorState edge : edges) {
                this.processEdge(edge.getEdge(), edge.getAdjNode(), prevEdge);
                prevEdge = edge.getEdge();
            }
            if (edges.isEmpty()) {
                this.setFound(false);
            } else {
                this.setFromNode(edges.get(0).getBaseNode());
                this.setFound(true);
            }
        }
    }
}

