/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.routing.Path;
import java.util.List;

public class MatchResult {
    private List<EdgeMatch> edgeMatches;
    private Path mergedPath;
    private double matchLength;
    private long matchMillis;
    private double gpxEntriesLength;
    private long gpxEntriesMillis;

    public MatchResult(List<EdgeMatch> edgeMatches) {
        this.setEdgeMatches(edgeMatches);
    }

    public void setEdgeMatches(List<EdgeMatch> edgeMatches) {
        if (edgeMatches == null) {
            throw new IllegalStateException("edgeMatches cannot be null");
        }
        this.edgeMatches = edgeMatches;
    }

    public void setGPXEntriesLength(double gpxEntriesLength) {
        this.gpxEntriesLength = gpxEntriesLength;
    }

    public void setGPXEntriesMillis(long gpxEntriesMillis) {
        this.gpxEntriesMillis = gpxEntriesMillis;
    }

    public void setMatchLength(double matchLength) {
        this.matchLength = matchLength;
    }

    public void setMatchMillis(long matchMillis) {
        this.matchMillis = matchMillis;
    }

    public void setMergedPath(Path mergedPath) {
        this.mergedPath = mergedPath;
    }

    public List<EdgeMatch> getEdgeMatches() {
        return this.edgeMatches;
    }

    public double getGpxEntriesLength() {
        return this.gpxEntriesLength;
    }

    public long getGpxEntriesMillis() {
        return this.gpxEntriesMillis;
    }

    public double getMatchLength() {
        return this.matchLength;
    }

    public long getMatchMillis() {
        return this.matchMillis;
    }

    public Path getMergedPath() {
        return this.mergedPath;
    }

    public String toString() {
        return "length:" + this.matchLength + ", seconds:" + (float)this.matchMillis / 1000.0f + ", matches:" + this.edgeMatches.toString();
    }
}

